package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.support.design.widget.TabLayout;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.LinearLayout;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.HistoryGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.HistoryItem;

import java.util.ArrayList;
import java.util.List;

public class HistoryActivity extends AbstractBaseActivity implements TabLayout.BaseOnTabSelectedListener {
    private AbsListView aqsContentView;
    private HistoryGridViewAdapter adapter;
    private LinearLayout loadingRl;
    private boolean mLoading;
    private ArrayList<HistoryItem> historyList;
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {

    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_history;
    }

    @Override
    public void initView() {
        showTitleClose(true);
        List<String> tags = new ArrayList<>();
        tags.add(getResources().getString(R.string.css_text_tab_processing));
        tags.add(getResources().getString(R.string.css_text_tab_fixed));
        showTitleTab(true, tags, this);
        aqsContentView = findViewById(R.id.css_history_aqs);
        loadingRl = findViewById(R.id.css_loading_layout);
    }

    @Override
    public void initData() {
        requestData(0);
    }

    private void requestData(final int statusType) {
        showLoading();
        BusinessRequest.getHistoryList(statusType, new RequestCallback<ArrayList<HistoryItem>>() {
            @Override
            public void onSuccess(final ArrayList<HistoryItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (result == null || result.isEmpty()) {
                            ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_history_empty, false);
                        }
                        historyList = result;
                        if (adapter == null) {
                            adapter = new HistoryGridViewAdapter(HistoryActivity.this, historyList);
                            aqsContentView.setAdapter(adapter);
                            aqsContentView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
                                @Override
                                public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
                                    goHistoryDetail(position);
                                }
                            });
                        } else {
                            adapter.setDataList(historyList);
                            adapter.notifyDataSetChanged();
                        }

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void goHistoryDetail(int position) {
        HistoryItem item = historyList.get(position);
        if (item != null) {
            Intent intent = new Intent(HistoryActivity.this, ChatDetailActivity.class);
            intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
            intent.putExtra(Constants.KEY_IS_UNREAD, item.status.equals(Constants.QA_STATUS_PROCESSED));
            startActivityForResult(intent, Constants.HISTORY_RESULT_CODE);
        }
    }
    private void showLoading() {
        mLoading = true;
        loadingRl.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                mLoading = false;
                loadingRl.setVisibility(View.GONE);

            }
        });
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (resultCode == Constants.HISTORY_RESULT_CODE) {
            if (data != null) {
                Bundle bundle = data.getExtras();
                if (bundle != null) {
                    long orderId = bundle.getLong(Constants.KEY_ORDER_ID);
                    int type = bundle.getInt(Constants.KEY_ORDER_CHANGE_TYPE);
                    if (historyList != null && !historyList.isEmpty()) {
                        for (HistoryItem item : historyList) {
                            if (item.id == orderId) {
                                if (type == Constants.ORDER_CHANGE_TO_READED) {
                                    item.status = Constants.QA_STATUS_PROCESSED_READ;
                                } else if (type == Constants.ORDER_CHANGE_TO_CLOSED) {
                                    item.status = Constants.QA_STATUS_CLOSED;
                                }
                                adapter.setDataList(historyList);
                                adapter.notifyDataSetChanged();
                                break;
                            }
                        }
                    }
                }

            }
        }
    }

    // tablayout 选中时候进行的回调
    @Override
    public void onTabSelected(TabLayout.Tab tab) {
        requestData(tab.getPosition());
    }

    @Override
    public void onTabUnselected(TabLayout.Tab tab) {

    }

    @Override
    public void onTabReselected(TabLayout.Tab tab) {

    }
}
