/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.view.KeyEvent;
import android.view.View;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FaqDetailActvity;
import com.css.sdk.cservice.adapter.SimpleTextGridViewAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import java.util.List;

public class FaqListActivity
extends AbstractBaseActivity {
    private AbsListView contentView;
    private boolean mLoading;
    private SimpleTextGridViewAdapter gridViewAdapter;
    private List<FaqItem> faqList;
    private LinearLayout loadingRoot;
    private EditText etSearch;
    private TextView cancelSearch;
    private TextView confirmSearch;
    private TextView nodataView;

    @Override
    protected void initExtraData() {
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faqlist;
    }

    @Override
    public void initView() {
        if (this.isLand) {
            this.showTitleBack(true);
            this.showTitleLargeSearch(true);
            this.contentView = (AbsListView)this.findViewById(R.id.css_faqs_list);
        } else {
            ImageView ivBack = (ImageView)this.findViewById(R.id.css_title_back);
            ivBack.setVisibility(0);
            ivBack.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    FaqListActivity.this.finish();
                }
            });
            this.contentView = (AbsListView)this.findViewById(R.id.css_recommedfaq_listView);
        }
        this.loadingRoot = (LinearLayout)this.findViewById(R.id.css_loading_layout);
        this.etSearch = (EditText)this.findViewById(R.id.css_title_search);
        this.cancelSearch = (TextView)this.findViewById(R.id.css_title_search_cancel);
        this.confirmSearch = (TextView)this.findViewById(R.id.css_title_search_confrim);
        this.nodataView = (TextView)this.findViewById(R.id.css_nodata);
        this.cancelSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqListActivity.this.etSearch.setText((CharSequence)"");
            }
        });
        this.confirmSearch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String targetStr = FaqListActivity.this.etSearch.getText().toString().trim();
                FaqListActivity.this.requestData(targetStr);
            }
        });
        this.contentView.setOnItemClickListener(new AdapterView.OnItemClickListener(){

            public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                FaqListActivity.this.goToFaqDetail(position);
            }
        });
    }

    private void goToFaqDetail(int position) {
        Intent i = new Intent((Context)this, FaqDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, this.faqList.get((int)position).id);
        i.putExtra(Constants.KEY_RECOMMEND_NAME, this.faqList.get(position).getFaqTypeByLanguage((Context)this));
        this.startActivity(i);
    }

    @Override
    public void initData() {
    }

    private void showEmptyView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FaqListActivity.this.nodataView.isShown()) {
                    FaqListActivity.this.nodataView.setVisibility(0);
                }
            }
        });
    }

    private void hideEmptyView() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqListActivity.this.nodataView.isShown()) {
                    FaqListActivity.this.nodataView.setVisibility(8);
                }
            }
        });
    }

    private void requestData(String content) {
        this.showLoading();
        this.hideEmptyView();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>(){

            @Override
            public void onSuccess(final List<FaqItem> result) {
                FaqListActivity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqListActivity.this.hideLoading();
                        FaqListActivity.this.faqList = result;
                        if (result.isEmpty()) {
                            FaqListActivity.this.showEmptyView();
                            FaqListActivity.this.contentView.setVisibility(8);
                            return;
                        }
                        FaqListActivity.this.contentView.setVisibility(0);
                        FaqListActivity.this.gridViewAdapter = new SimpleTextGridViewAdapter((Context)FaqListActivity.this, FaqListActivity.this.faqList);
                        FaqListActivity.this.contentView.setAdapter((ListAdapter)FaqListActivity.this.gridViewAdapter);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqListActivity.this.showEmptyView();
                FaqListActivity.this.hideLoading();
                FaqListActivity.this.showError(code);
            }
        });
    }

    private void showLoading() {
        this.mLoading = true;
        this.loadingRoot.setVisibility(0);
    }

    private void hideLoading() {
        if (!this.mLoading) {
            return;
        }
        this.mLoading = false;
        this.loadingRoot.setVisibility(8);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.mLoading && keyCode == 4) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }
}

