/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.AbstractBaseActivity;
import com.css.sdk.cservice.activity.FeedBackActivity;
import com.css.sdk.cservice.activity.SubmitSuccessActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssRoundBtn;

public class FaqDetailActvity
extends AbstractBaseActivity {
    private String recommendId;
    private TextView answerTv;
    private CssRoundBtn unsolve;
    private CssRoundBtn solve;
    private LinearLayout loadingLl;
    private TextView bottomHintTv;
    private FaqDetail detail;
    private RelativeLayout bottomBtnLl;
    private String faqName;
    private String quId = "";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        this.recommendId = this.getIntent().getStringExtra(Constants.KEY_RECOMMEND_ID);
        this.faqName = this.getIntent().getStringExtra(Constants.KEY_RECOMMEND_NAME);
        this.quId = this.getIntent().getStringExtra(Constants.KEY_QU_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq_detail_actvity;
    }

    @Override
    public void initView() {
        this.showTitleClose(true);
        if (this.faqName.length() >= 60) {
            String substring = this.faqName.substring(0, 60);
            this.faqName = substring + "\n" + this.faqName.substring(60, this.faqName.length());
        }
        this.showTitleName(true, this.faqName);
        this.answerTv = (TextView)this.findViewById(R.id.css_answer);
        this.answerTv.setVisibility(8);
        this.unsolve = (CssRoundBtn)this.findViewById(R.id.css_rl_unsolveqa);
        this.bottomHintTv = (TextView)this.findViewById(R.id.css_hint);
        this.bottomBtnLl = (RelativeLayout)this.findViewById(R.id.css_bottom_rl);
        this.bottomBtnLl.setVisibility(8);
        this.unsolve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqDetailActvity.this.evaluate(false);
            }
        });
        this.solve = (CssRoundBtn)this.findViewById(R.id.css_rl_solveqa);
        this.solve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FaqDetailActvity.this.evaluate(true);
            }
        });
        this.loadingLl = (LinearLayout)this.findViewById(R.id.css_loading_layout);
    }

    @Override
    public void initData() {
        this.requestData();
    }

    private void showLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (!FaqDetailActvity.this.loadingLl.isShown()) {
                    FaqDetailActvity.this.loadingLl.setVisibility(0);
                }
            }
        });
    }

    private void hideLoading() {
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (FaqDetailActvity.this.loadingLl.isShown()) {
                    FaqDetailActvity.this.loadingLl.setVisibility(8);
                }
            }
        });
    }

    private void evaluate(final boolean isHelp) {
        this.showLoading();
        BusinessRequest.evaluateFqa(this.recommendId, isHelp, new RequestCallback<String>(){

            @Override
            public void onSuccess(String result) {
                FaqDetailActvity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqDetailActvity.this.hideLoading();
                        if (isHelp) {
                            FaqDetailActvity.this.bottomHintTv.setText(R.string.css_string_thanks_for_evaluate);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(8);
                            if (TextUtils.isEmpty((CharSequence)FaqDetailActvity.this.quId)) {
                                ToastHelper.showShortToastCenter(FaqDetailActvity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                            } else {
                                FaqDetailActvity.this.backToSubmitSuccess(isHelp);
                            }
                            FaqDetailActvity.this.finish();
                        } else if (TextUtils.isEmpty((CharSequence)FaqDetailActvity.this.quId)) {
                            FaqDetailActvity.this.bottomHintTv.setText(R.string.css_text_hint_nohelp);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(0);
                            FaqDetailActvity.this.solve.setVisibility(8);
                            FaqDetailActvity.this.showFeedback();
                        } else {
                            ToastHelper.showShortToastCenter(FaqDetailActvity.this.getResources().getString(R.string.css_string_thanks_for_evaluate));
                            FaqDetailActvity.this.finish();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqDetailActvity.this.hideLoading();
                FaqDetailActvity.this.showError(code);
            }
        });
    }

    private void showFeedback() {
        this.unsolve.setBackground(this.getResources().getDrawable(R.drawable.css_shape_rounded_bg_whitesolied_blueline));
        this.unsolve.setText(this.getResources().getString(R.string.css_string_feedback_new));
        this.unsolve.changeTextColor(this.getResources().getColor(R.color.css_default_blue));
        this.unsolve.setImgVisible(8);
        this.unsolve.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent((Context)FaqDetailActvity.this, FeedBackActivity.class);
                FaqDetailActvity.this.startActivity(intent);
                FaqDetailActvity.this.finish();
            }
        });
    }

    private void backToSubmitSuccess(boolean isHelp) {
        Intent intent = new Intent((Context)this, SubmitSuccessActivity.class);
        intent.putExtra(Constants.KEY_DETIAL_EVALUATE_RESULT, isHelp);
        this.setResult(6001, intent);
    }

    private void requestData() {
        this.showLoading();
        BusinessRequest.getFaqDetail((Context)this, this.recommendId, new RequestCallback<FaqDetail>(){

            @Override
            public void onSuccess(final FaqDetail result) {
                FaqDetailActvity.this.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        FaqDetailActvity.this.hideLoading();
                        FaqDetailActvity.this.detail = result;
                        if (!TextUtils.isEmpty((CharSequence)((FaqDetailActvity)FaqDetailActvity.this).detail.answer)) {
                            FaqDetailActvity.this.answerTv.setText((CharSequence)((FaqDetailActvity)FaqDetailActvity.this).detail.answer);
                            FaqDetailActvity.this.answerTv.setVisibility(0);
                            FaqDetailActvity.this.bottomBtnLl.setVisibility(0);
                        } else {
                            FaqDetailActvity.this.answerTv.setVisibility(8);
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                FaqDetailActvity.this.hideLoading();
                FaqDetailActvity.this.showError(code);
            }
        });
    }
}

