/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.view;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ListView;
import com.css.sdk.cservice.view.SlideItem;

public class SlideListView
extends ListView {
    private SlideItem mTouchView = null;
    private float mDownX;
    private float mDownY;
    private int mTouchState;
    private int mTouchPosition;
    private static final int TOUCH_STATE_NONE = 0;
    private static final int TOUCH_STATE_X = 1;
    private static final int TOUCH_STATE_Y = 2;
    private static final int MAX_Y = 5;
    private static final int MAX_X = 3;
    private boolean itemClick = true;
    private OnItemClickListener itemClickListener;

    public SlideListView(Context context) {
        super(context);
    }

    public SlideListView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public SlideListView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() != 0 && this.mTouchView == null) {
            return super.onTouchEvent(ev);
        }
        switch (ev.getAction()) {
            case 0: {
                this.itemClick = true;
                int oldPosition = this.mTouchPosition;
                this.mDownX = ev.getX();
                this.mDownY = ev.getY();
                this.mTouchState = 0;
                this.mTouchPosition = this.pointToPosition((int)ev.getX(), (int)ev.getY());
                if (this.mTouchPosition == oldPosition && this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchState = 1;
                    this.mTouchView.onSwipe(ev);
                    this.itemClick = false;
                    return true;
                }
                View currentView = this.getChildAt(this.mTouchPosition - this.getFirstVisiblePosition());
                if (this.mTouchView != null && this.mTouchView.isOpen()) {
                    this.mTouchView.smoothCloseMenu();
                    this.mTouchView = null;
                    this.itemClick = false;
                    return super.onTouchEvent(ev);
                }
                if (currentView instanceof SlideItem) {
                    this.mTouchView = (SlideItem)currentView;
                }
                if (this.mTouchView == null) break;
                this.mTouchView.onSwipe(ev);
                break;
            }
            case 2: {
                float dy = Math.abs(ev.getY() - this.mDownY);
                float dx = Math.abs(ev.getX() - this.mDownX);
                if (this.mTouchState == 1) {
                    if (this.mTouchView != null) {
                        this.mTouchView.onSwipe(ev);
                    }
                    return true;
                }
                if (this.mTouchState != 0) break;
                if (Math.abs(dy) > 5.0f) {
                    this.mTouchState = 2;
                    break;
                }
                if (!(dx > 3.0f)) break;
                this.mTouchState = 1;
                break;
            }
            case 1: {
                if (this.mTouchState == 1) {
                    if (this.mTouchView != null) {
                        this.mTouchView.onSwipe(ev);
                        if (!this.mTouchView.isOpen()) {
                            this.mTouchPosition = -1;
                            this.mTouchView = null;
                        }
                    }
                    ev.setAction(3);
                    super.onTouchEvent(ev);
                    return true;
                }
                if (this.mTouchState != 0 || !this.itemClick || this.itemClickListener == null || this.mTouchPosition <= -1) break;
                this.itemClickListener.clicked(this.mTouchPosition);
            }
        }
        return super.onTouchEvent(ev);
    }

    public void setItemClickListener(OnItemClickListener itemClickListener) {
        this.itemClickListener = itemClickListener;
    }

    public static interface OnItemClickListener {
        public void clicked(int var1);
    }
}

