/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;

public class ThreadHelper {
    private static Handler mMainHandler;
    private static Handler mWorkHandler;

    private static void initWorkHandler() {
        if (mWorkHandler == null) {
            HandlerThread thread = new HandlerThread("css_sdk");
            thread.start();
            mWorkHandler = new Handler(thread.getLooper());
        }
    }

    private static void initMainHandler() {
        if (mMainHandler == null) {
            mMainHandler = new Handler(Looper.getMainLooper());
        }
    }

    public static void runOnMainThread(Runnable r) {
        ThreadHelper.initMainHandler();
        mMainHandler.post(r);
    }

    public static void runOnMainThread(Runnable r, long delay) {
        ThreadHelper.initMainHandler();
        mMainHandler.postDelayed(r, delay);
    }

    public static void removeOnMainThread(Runnable r) {
        if (mMainHandler != null && r != null) {
            mMainHandler.removeCallbacks(r);
        }
    }

    public static void runOnWorkThread(Runnable r) {
        ThreadHelper.initWorkHandler();
        mWorkHandler.post(r);
    }

    public static void runOnWorkThread(Runnable r, long delay) {
        ThreadHelper.initWorkHandler();
        mWorkHandler.postDelayed(r, delay);
    }

    public static void removeOnWorkThread(Runnable r) {
        if (mWorkHandler != null && r != null) {
            mWorkHandler.removeCallbacks(r);
        }
    }

    static {
        ThreadHelper.initMainHandler();
        ThreadHelper.initWorkHandler();
    }
}

