/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.BaseActivity;
import java.util.List;

public abstract class AbstractBaseActivity
extends BaseActivity {
    protected abstract void initExtraData();

    public abstract int getLayoutId();

    public abstract void initView();

    public abstract void initData();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.initExtraData();
        this.setContentView(this.getLayoutId());
        this.initView();
        this.initData();
    }

    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = (RelativeLayout)this.findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? 0 : 8);
        titleBack.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractBaseActivity.this.finish();
            }
        });
    }

    protected void showTitleClose(boolean show) {
        RelativeLayout closeRoot = (RelativeLayout)this.findViewById(R.id.css_title_close);
        closeRoot.setVisibility(show ? 0 : 8);
        closeRoot.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AbstractBaseActivity.this.finish();
            }
        });
    }

    protected void showTitleName(boolean show, String name) {
        RelativeLayout titleTvRoot = (RelativeLayout)this.findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? 0 : 8);
        if (!show) {
            return;
        }
        TextView titleTv = (TextView)this.findViewById(R.id.css_title_tv);
        titleTv.setText((CharSequence)name);
    }

    protected void showTitleLargeSearch(boolean show) {
        LinearLayout largeSeachRoot = (LinearLayout)this.findViewById(R.id.rl_title_largesearch);
        largeSeachRoot.setVisibility(show ? 0 : 8);
    }

    protected View showTitleShortSearch(boolean show) {
        LinearLayout searchRoot = (LinearLayout)this.findViewById(R.id.rl_title_shortsearch);
        searchRoot.setVisibility(show ? 0 : 8);
        return searchRoot;
    }

    protected void showTitleTab(boolean show, List<String> tags, TabLayout.BaseOnTabSelectedListener listener) {
        RelativeLayout tabLayout = (RelativeLayout)this.findViewById(R.id.rl_titile_tab);
        tabLayout.setVisibility(show ? 0 : 8);
        if (!show) {
            return;
        }
        TabLayout mTabLayout = (TabLayout)this.findViewById(R.id.css_title_tab_layout);
        for (String tag : tags) {
            mTabLayout.addTab(mTabLayout.newTab().setText((CharSequence)tag));
        }
        mTabLayout.addOnTabSelectedListener(listener);
    }

    protected void goActvityForResult(Context clz, Class targetClz, int requestCode) {
        Intent intent = new Intent(clz, targetClz);
        this.startActivityForResult(intent, requestCode);
    }

    protected int dp2px(Context context, float dpValue) {
        return (int)TypedValue.applyDimension((int)1, (float)dpValue, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected Point getScreenMsg(Context context) {
        Point point = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getSize(point);
        return point;
    }
}

