/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.widget.EditText;

public class SoftHideKeyBoardUtil {
    private View parent;
    private View content;
    private View contact;
    private int usableHeightPrevious;
    private ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){

        public void onGlobalLayout() {
            SoftHideKeyBoardUtil.this.possiblyResizeChildOfContent();
        }
    };

    public static void assistActivity(View parent, EditText content, EditText contact) {
        new SoftHideKeyBoardUtil(parent, content, contact);
    }

    private SoftHideKeyBoardUtil(View parent, EditText content, EditText contact) {
        this.parent = parent;
        this.content = content;
        this.contact = contact;
        parent.getViewTreeObserver().addOnGlobalLayoutListener(this.onGlobalLayoutListener);
    }

    private void possiblyResizeChildOfContent() {
        Rect r = new Rect();
        this.parent.getWindowVisibleDisplayFrame(r);
        int usableHeightNow = r.bottom - r.top;
        if (usableHeightNow != this.usableHeightPrevious) {
            int usableHeightSansKeyboard = this.parent.getRootView().getHeight();
            int heightDifference = usableHeightSansKeyboard - usableHeightNow;
            if (heightDifference > usableHeightSansKeyboard / 4) {
                int srollHeight;
                int[] location = new int[2];
                if (this.contact.isFocused()) {
                    this.contact.getLocationInWindow(location);
                    srollHeight = location[1] + this.contact.getHeight() - r.bottom;
                    if (srollHeight > 0) {
                        this.parent.scrollTo(0, srollHeight);
                    } else {
                        this.parent.getViewTreeObserver().removeOnGlobalLayoutListener(this.onGlobalLayoutListener);
                    }
                }
                if (this.content.isFocused()) {
                    this.content.getLocationInWindow(location);
                    srollHeight = location[1] - r.bottom + this.content.getHeight() / 3;
                    if (srollHeight > 0) {
                        this.parent.scrollTo(0, srollHeight);
                    }
                }
            } else {
                this.parent.scrollTo(0, 0);
            }
            this.usableHeightPrevious = usableHeightNow;
        }
    }
}

