/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Layout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.CssVideoPlayActivity;
import com.css.sdk.cservice.activity.PreviewActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.data.Chat;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.imageloader.ImageLoader;
import java.util.ArrayList;

public class ChatAdapter
extends BaseAdapter {
    private Context mContext;
    private OrderDetail detail;
    private LayoutInflater inflater;
    private final int ASK = 0;
    private final int ANSWER = 1;
    private final int HINT = 2;

    public ChatAdapter(Context mContext, OrderDetail detail) {
        this.mContext = mContext;
        this.detail = detail;
        this.inflater = LayoutInflater.from((Context)mContext);
    }

    public void bindData(OrderDetail detail) {
        this.detail = detail;
    }

    public int getCount() {
        if (this.detail == null || this.detail.chats == null) {
            return 0;
        }
        if (this.detail.status.equals(Constants.QA_STATUS_WAITING) || this.detail.status.equals(Constants.QA_STATUS_WAITING_APPEND) || this.detail.status.equals(Constants.QA_STATUS_CLOSED) || this.detail.status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT) || this.detail.status.equals(Constants.QA_STATUS_PROCESSING)) {
            return this.detail.chats.size() + 1;
        }
        return this.detail.chats.size();
    }

    public Object getItem(int position) {
        if (this.detail == null || this.detail.chats == null) {
            return null;
        }
        if (this.getCount() > this.detail.chats.size() && position == this.getCount() - 1) {
            return null;
        }
        return this.detail.chats.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        switch (this.getItemViewType(position)) {
            case 2: {
                return this.handleHint(convertView);
            }
            case 0: {
                return this.handleChat(position, convertView, true);
            }
            case 1: {
                return this.handleChat(position, convertView, false);
            }
        }
        return convertView;
    }

    private View handleHint(View convertView) {
        HintViewHolder hintViewHolder = null;
        if (convertView == null) {
            convertView = this.inflater.inflate(R.layout.css_question_detail_item_hint, null);
            hintViewHolder = new HintViewHolder(convertView);
            convertView.setTag((Object)hintViewHolder);
        } else {
            hintViewHolder = (HintViewHolder)convertView.getTag();
        }
        if (this.detail.status.equals(Constants.QA_STATUS_WAITING) || this.detail.status.equals(Constants.QA_STATUS_WAITING_APPEND)) {
            hintViewHolder.hint.setText(R.string.css_string_fqa_status_waiting_or_append);
        } else if (this.detail.status.equals(Constants.QA_STATUS_PROCESSING)) {
            hintViewHolder.hint.setText(R.string.css_string_fqa_status_processing);
        } else if (this.detail.status.equals(Constants.QA_STATUS_CLOSED_TIMEOUT)) {
            hintViewHolder.hint.setText(R.string.css_string_fqa_status_close);
        } else if (this.detail.status.equals(Constants.QA_STATUS_CLOSED)) {
            hintViewHolder.hint.setText(R.string.css_string_fqa_status_close_by_yourself);
        }
        return convertView;
    }

    private View handleChat(int position, View convertView, boolean isAsk) {
        ChatViewHolder viewHolder = null;
        if (convertView == null) {
            convertView = isAsk ? this.inflater.inflate(R.layout.css_question_detail_chat_ask, null) : this.inflater.inflate(R.layout.css_question_detail_chat_answer, null);
            viewHolder = new ChatViewHolder(convertView);
            convertView.setTag((Object)viewHolder);
        } else {
            viewHolder = (ChatViewHolder)convertView.getTag();
        }
        Chat chat = this.detail.chats.get(position);
        if (chat.pics != null && chat.pics.size() > 0 || chat.videos != null && chat.videos.size() > 0) {
            viewHolder.picsLl.setVisibility(0);
            this.dealMedias(viewHolder, chat);
        } else {
            viewHolder.picsLl.setVisibility(8);
        }
        if (this.getItemViewType(position) == 0) {
            viewHolder.original.setTextColor(this.mContext.getResources().getColor(R.color.css_color_white));
        } else if (this.getItemViewType(position) == 1) {
            viewHolder.original.setTextColor(this.mContext.getResources().getColor(R.color.css_color_black_1));
        }
        viewHolder.original.setText((CharSequence)chat.original);
        if (TextUtils.isEmpty((CharSequence)chat.translation)) {
            viewHolder.translationLl.setVisibility(8);
        } else {
            viewHolder.translationLl.setVisibility(0);
            viewHolder.translation.setText((CharSequence)chat.translation);
            int width_o = (int)Layout.getDesiredWidth((CharSequence)viewHolder.original.getText(), (TextPaint)viewHolder.original.getPaint());
            int width_t = (int)Layout.getDesiredWidth((CharSequence)viewHolder.translation.getText(), (TextPaint)viewHolder.translation.getPaint());
            ViewGroup.LayoutParams params = viewHolder.line.getLayoutParams();
            params.width = width_o > width_t ? width_o : width_t;
            viewHolder.line.setLayoutParams(params);
        }
        return convertView;
    }

    private void dealMedias(ChatViewHolder holder, Chat chat) {
        int mediaNumber = chat.pics.size() + chat.videos.size();
        this.setImageVisible(holder, mediaNumber);
        this.showMedia(holder, chat);
    }

    private void showMedia(ChatViewHolder holder, final Chat chat) {
        int i;
        int picSize = chat.pics.size();
        int videoSize = chat.videos.size();
        if (picSize > 0) {
            for (i = 0; i < picSize; ++i) {
                ImageLoader.getInstance().load(chat.pics.get(i), holder.mediaHolderImages[i]);
                holder.mediaHolderImages[i].setTag((Object)chat.pics.get(i));
                final int position = i;
                holder.mediaHolderImages[i].setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ChatAdapter.this.toPreviewPicActivity(chat.pics, position);
                    }
                });
            }
        }
        if (videoSize > 0) {
            int n = i = picSize == 0 ? 0 : picSize;
            while (i < picSize + videoSize) {
                holder.mediaHolderImages[i].setImageResource(R.drawable.css_video_holder);
                holder.mediaHolderImages[i].setTag((Object)chat.videos.get(picSize > 0 ? i - picSize : i));
                final String path = chat.videos.get(picSize > 0 ? i - picSize : i);
                holder.mediaHolderImages[i].setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        ChatAdapter.this.toPreviewVideoActivity(path);
                    }
                });
                ++i;
            }
        }
    }

    private void setImageVisible(ChatViewHolder holder, int mediaNumber) {
        holder.pic1.setVisibility(0);
        holder.pic2.setVisibility(mediaNumber > 1 ? 0 : 8);
        holder.pic3.setVisibility(mediaNumber > 2 ? 0 : 8);
    }

    private void toPreviewPicActivity(ArrayList<String> images, int position) {
        if (images != null && images.size() > 0) {
            Intent intent = new Intent(this.mContext, PreviewActivity.class);
            Bundle b = new Bundle();
            b.putStringArrayList(Constants.KEY_ALL_PICS, images);
            b.putInt(Constants.KEY_POSITION, position);
            b.putInt(Constants.KEY_PREVIEW_TYPE, Constants.PREVIEW_TYPE_VIEW);
            intent.putExtras(b);
            this.mContext.startActivity(intent);
        }
    }

    private void toPreviewVideoActivity(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            LogUtils.w("invalidated data of video", null);
            return;
        }
        Intent intent = new Intent(this.mContext, CssVideoPlayActivity.class);
        intent.setFlags(0x10000000);
        intent.putExtra(CssVideoPlayActivity.VIDEO_PATH, path);
        this.mContext.startActivity(intent);
    }

    public int getViewTypeCount() {
        return 3;
    }

    public int getItemViewType(int position) {
        if (this.getCount() > this.detail.chats.size() && position == this.getCount() - 1) {
            return 2;
        }
        if (this.detail.chats.get((int)position).send.equals("ask")) {
            return 0;
        }
        return 1;
    }

    class ChatViewHolder {
        TextView original;
        TextView translation;
        LinearLayout translationLl;
        LinearLayout picsLl;
        ImageView pic1;
        ImageView pic2;
        ImageView pic3;
        ImageView[] mediaHolderImages = new ImageView[3];
        View line;

        public ChatViewHolder(View view) {
            this.original = (TextView)view.findViewById(R.id.css_chat_original_tv);
            this.translation = (TextView)view.findViewById(R.id.css_chat_translation_tv);
            this.translationLl = (LinearLayout)view.findViewById(R.id.css_chat_translation_ll);
            this.picsLl = (LinearLayout)view.findViewById(R.id.css_chat_pic_ll);
            this.line = view.findViewById(R.id.css_chat_line);
            this.pic1 = (ImageView)view.findViewById(R.id.css_chat_pic1);
            this.pic2 = (ImageView)view.findViewById(R.id.css_chat_pic2);
            this.pic3 = (ImageView)view.findViewById(R.id.css_chat_pic3);
            this.mediaHolderImages[0] = this.pic1;
            this.mediaHolderImages[1] = this.pic2;
            this.mediaHolderImages[2] = this.pic3;
        }
    }

    class HintViewHolder {
        TextView hint;

        public HintViewHolder(View view) {
            this.hint = (TextView)view.findViewById(R.id.css_question_detail_hint);
        }
    }
}

