package com.css.sdk.cservice.adapter;

import android.content.Context;
import android.support.v4.view.PagerAdapter;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;

import com.css.sdk.R;
import com.css.sdk.cservice.imageloader.ImageLoader;

import java.util.ArrayList;

public class ImagePagerAdapter extends PagerAdapter {

    private Context mContext;
    private ArrayList<String> mImgList;

    public ImagePagerAdapter(Context context, ArrayList<String> imgList) {
        this.mContext = context;
        mImgList = imgList;
    }

    @Override
    public int getCount() {
        return mImgList == null ? 0 : mImgList.size();
    }

    @Override
    public boolean isViewFromObject(View view, Object object) {
        return view == object;
    }

    @Override
    public void destroyItem(ViewGroup container, int position, Object object) {
        container.removeView((View)object);
    }

    @Override
    public Object instantiateItem(ViewGroup container, final int position) {
        ImageView iv = new ImageView(mContext);
        iv.setScaleType(ImageView.ScaleType.FIT_CENTER);
        container.addView(iv);
        iv.setImageResource(R.drawable.css_pic_placeholder);
        ImageLoader.getInstance().load(mImgList.get(position),iv);
        return iv;
    }
}
