package com.css.sdk.cservice.activity;

import android.Manifest;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.Message;
import android.provider.MediaStore;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.widget.GridView;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.PictureAdapter;
import com.css.sdk.cservice.adapter.PictureAlbumDirectoryAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ThreadHelper;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.data.AlbumData;
import com.css.sdk.cservice.data.ImageFloder;
import com.css.sdk.cservice.view.FolderPopWindow;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;

public class SelectPictureActivity extends BaseActivity {

    private int selectedPicNum;//已选择的图片数量
    private int currentMaxNum;//当前最多可选择的图片数量

    private TextView cancel;
    private TextView title;
    private TextView preview;
    private TextView submit;
    private GridView gridView;

    private FolderPopWindow folderPopWindow;
    private PictureAdapter adapter;

    private ImageFloder currentImageFolder;//当前所选择的图片文件夹

    private ImageFloder imageAll;//所有图片
    private ArrayList<ImageFloder> mDirPaths = new ArrayList<ImageFloder>();//所有图片文件夹集合


    private static final int PERMISSION_READ_EXTERNAL_REQUEST_CODE = 0x00000011;
    private Handler mHandler;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.css_activity_select_picture);

        selectedPicNum = getIntent().getIntExtra("selectedPictureNum", 0);
        currentMaxNum = 3 - selectedPicNum;
        if (mHandler == null) {
            mHandler = new Handler() {
                public void handleMessage(android.os.Message msg) {
                    int what = msg.what;
                    switch (what) {
                        case 1:
                            AlbumData data = (AlbumData) msg.obj;
                            mDirPaths.addAll(data.getDirPaths());
                            imageAll.images.addAll(data.getAllImages());
                            if (imageAll.images.isEmpty()) {
                                ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_album_empty, false);
                                finish();
                            } else {
                                imageAll.setFirstImagePath(data.getAllImages().get(0));
                                adapter.notifyDataSetChanged();
                                folderPopWindow.bindFolder(mDirPaths);
                            }
                            break;

                        default:
                            break;
                    }
                }
            };
        }

        initView();

    }

    private void initView() {
        imageAll = new ImageFloder();
        imageAll.setDir(getResources().getString(R.string.css_string_all_picture));
        imageAll.setChecked(true);
        currentImageFolder = imageAll;
        mDirPaths.add(imageAll);
        cancel = findViewById(R.id.css_tv_cancel);
        cancel.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                back();
            }
        });
        title = findViewById(R.id.css_tv_title);
        title.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (folderPopWindow.isShowing()) {
                    folderPopWindow.dismiss();
                } else {
                    if (currentImageFolder.images != null && currentImageFolder.images.size() > 0) {
                        folderPopWindow.showAsDropDown(title);
                    }
                }
            }
        });
        preview = findViewById(R.id.css_tv_preview);
        preview.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                toPreviewActivity(adapter.getSelectedPics(), 0);
            }
        });
        submit = findViewById(R.id.css_tv_submit);
        submit.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                submit();
            }
        });
        gridView = findViewById(R.id.css_gridview);
        adapter = new PictureAdapter(this, currentImageFolder.images, currentMaxNum);
        adapter.setListener(new PictureAdapter.OnEventListener() {
            @Override
            public void onPreview(int position) {
                toPreviewActivity(currentImageFolder.images, position);
            }

            @Override
            public void selectChanged() {
                submit.setEnabled(adapter.getSelectedPics().size() > 0);
                changeUI();
            }
        });
        gridView.setAdapter(adapter);
        folderPopWindow = new FolderPopWindow(this);
        folderPopWindow.setPictureTitleView(title);
        folderPopWindow.setOnItemClickListener(new PictureAlbumDirectoryAdapter.OnItemClickListener() {
            @Override
            public void onItemClick(String folderName, ImageFloder floder) {
                title.setText(folderName);
                currentImageFolder = floder;
                adapter.bindDatas(currentImageFolder.images);
                adapter.notifyDataSetChanged();
                folderPopWindow.dismiss();
            }
        });
        checkPermissionAndLoadImages();
    }

    private void back() {
        if (folderPopWindow.isShowing()) {
            folderPopWindow.dismiss();
        } else {
            finish();
        }
    }

    /**
     * 获取本地图片
     */
    private void checkPermissionAndLoadImages() {
        if (!Environment.getExternalStorageState().equals(Environment.MEDIA_MOUNTED)) {
            return;
        }
        int hasWriteExternalPermission = ContextCompat.checkSelfPermission(this,
                Manifest.permission.WRITE_EXTERNAL_STORAGE);
        if (hasWriteExternalPermission == PackageManager.PERMISSION_GRANTED) {
            //有权限，加载图片。
            loadImageForSDCard();
        } else {
            //没有权限，申请权限。
            ActivityCompat.requestPermissions(SelectPictureActivity.this,
                    new String[]{Manifest.permission.READ_EXTERNAL_STORAGE}, PERMISSION_READ_EXTERNAL_REQUEST_CODE);
        }
    }


    /**
     * 处理权限申请的回调。
     */
    @Override
    public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
        if (requestCode == PERMISSION_READ_EXTERNAL_REQUEST_CODE) {
            if (grantResults.length > 0
                    && grantResults[0] == PackageManager.PERMISSION_GRANTED) {
                //允许权限，加载图片。
                loadImageForSDCard();
            } else {
                //拒绝权限，弹出提示框。
                finish();
            }
        }
    }

    private void submit() {
        Intent intent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putStringArrayList(Constants.KEY_SELECTED_PICS, adapter.getSelectedPics());
        intent.putExtras(bundle);
        setResult(RESULT_OK, intent);
        back();
    }

    /**
     * 处理图片预览页返回的结果
     *
     * @param requestCode
     * @param resultCode
     * @param data
     */
    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == Constants.PREVIEW_RESULT_CODE) {
            if (data != null) {
                Bundle b = data.getExtras();
                ArrayList<String> list = b.getStringArrayList(Constants.KEY_SELECTED_PICS);
                if (list != null && !list.isEmpty()) {
                    adapter.setSelectedPics(list);
                }
                if (data.getBooleanExtra(Constants.KEY_IS_CONFIRM, false)) {
                    //如果用户在预览页点击了确定，就直接把用户选中的图片返回给用户。
                    submit();
                } else {
                    //否则，就刷新当前页面。
                    if (list != null && !list.isEmpty()) {
                        adapter.notifyDataSetChanged();
                    }
                    changeUI();
                }
            }

        }
    }

    private void changeUI() {
        StringBuilder sb = new StringBuilder();
        sb.append(getResources().getString(R.string.css_string_submit)).append("(").append(adapter.getSelectedPics().size())
                .append("/").append(currentMaxNum).append(")");
        submit.setText(sb.toString());
        sb.delete(0, sb.length());

        sb.append(getString(R.string.css_string_preview)).append("(").append(adapter.getSelectedPics().size()).append(")");
        preview.setText(sb.toString());
    }

    /**
     * 从SDCard加载图片。
     */
    private void loadImageForSDCard() {
        ThreadHelper.runOnWorkThread(new Runnable() {
            @Override
            public void run() {
                ArrayList<String> allImages = new ArrayList<>();
                HashMap<String, Integer> tmpDir = new HashMap<String, Integer>();
                ArrayList<ImageFloder> mDirPaths = new ArrayList<ImageFloder>();
                Cursor mCursor = getContentResolver().query(MediaStore.Images.Media.EXTERNAL_CONTENT_URI,
                        new String[]{
                                MediaStore.Images.Media.DATA,
                                MediaStore.Images.Media.DISPLAY_NAME,
                                MediaStore.Images.Media.DATE_ADDED,
                                MediaStore.Images.Media._ID,
                                MediaStore.Images.Media.MIME_TYPE},
                        null,
                        null,
                        MediaStore.Images.Media.DATE_ADDED);

                if (mCursor.moveToLast()) {
                    int _date = mCursor.getColumnIndex(MediaStore.Images.Media.DATA);
                    do {

                        // 获取图片的路径
                        String path = mCursor.getString(_date);
                        allImages.add(path);

                        // 获取该图片的父路径名
                        File parentFile = new File(path).getParentFile();
                        if (parentFile == null) {
                            continue;
                        }

                        ImageFloder imageFloder = null;
                        String dirPath = parentFile.getAbsolutePath();

                        if (!tmpDir.containsKey(dirPath)) {
                            // 初始化imageFloder
                            imageFloder = new ImageFloder();
                            imageFloder.setDir(dirPath);
                            imageFloder.setFirstImagePath(path);
                            mDirPaths.add(imageFloder);
                            tmpDir.put(dirPath, mDirPaths.indexOf(imageFloder));
                        } else {
                            imageFloder = mDirPaths.get(tmpDir.get(dirPath));
                        }

                        imageFloder.images.add(path);
                    } while (mCursor.moveToPrevious());
                }

                mCursor.close();
                Message msg = new Message();
                AlbumData data = new AlbumData(allImages, mDirPaths);
                msg.obj = data;
                msg.what = 1;
                if (mHandler != null) {
                    mHandler.sendMessage(msg);
                }
            }
        });
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (mHandler != null) {

            mHandler.removeCallbacksAndMessages(null);

            mHandler = null;

        }
    }

    private void toPreviewActivity(ArrayList<String> images, int position) {
        if (images != null && !images.isEmpty()) {
            Intent intent = new Intent(this, PreviewActivity.class);
            Bundle b = new Bundle();
            b.putStringArrayList(Constants.KEY_ALL_PICS, images);
            b.putStringArrayList(Constants.KEY_SELECTED_PICS, adapter.getSelectedPics());
            b.putInt(Constants.KEY_MAX_NUM, currentMaxNum);
            b.putInt(Constants.KEY_POSITION, position);
            b.putInt(Constants.KEY_PREVIEW_TYPE, Constants.PREVIEW_TYPE_SELECT);

            intent.putExtras(b);
            startActivityForResult(intent, Constants.PREVIEW_RESULT_CODE);
        }
    }
}
