package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.os.Bundle;
import android.support.v4.view.ViewPager;
import android.view.View;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.ImagePagerAdapter;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.view.CViewPager;

import java.util.ArrayList;

public class PreviewActivity extends BaseActivity {

    private ArrayList<String> mImages;
    private ArrayList<String> selectImages;
    private int maxNum;
    private int position;
    private int type;

    private TextView selectTv;//选择
    private TextView confirmTv;//提交
    private TextView indicatorTv;
    private CViewPager viewPager;

    private BitmapDrawable mSelectDrawable;
    private BitmapDrawable mUnSelectDrawable;

    private boolean isConfirm = false;
    private RelativeLayout bottomBarRl;
    private RelativeLayout backBtn;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.css_activity_preview_image);
        Bundle b = getIntent().getExtras();
        if (b != null) {
            maxNum = b.getInt(Constants.KEY_MAX_NUM);
            position = b.getInt(Constants.KEY_POSITION);
            mImages = b.getStringArrayList(Constants.KEY_ALL_PICS);
            selectImages = b.getStringArrayList(Constants.KEY_SELECTED_PICS);
            type = b.getInt(Constants.KEY_PREVIEW_TYPE, 1);
        }

        Resources resources = getResources();
        Bitmap selectBitmap = BitmapFactory.decodeResource(resources, R.drawable.css_pic_checked);
        mSelectDrawable = new BitmapDrawable(resources, selectBitmap);
        mSelectDrawable.setBounds(0, 0, selectBitmap.getWidth(), selectBitmap.getHeight());

        Bitmap unSelectBitmap = BitmapFactory.decodeResource(resources, R.drawable.css_pic_uncheck);
        mUnSelectDrawable = new BitmapDrawable(resources, unSelectBitmap);
        mUnSelectDrawable.setBounds(0, 0, unSelectBitmap.getWidth(), unSelectBitmap.getHeight());
        initView();
    }

    private void initView() {
        selectTv = findViewById(R.id.css_tv_select);
        confirmTv = findViewById(R.id.css_tv_confirm);
        indicatorTv = findViewById(R.id.css_tv_indicator);
        viewPager = findViewById(R.id.css_vp_image);
        bottomBarRl = findViewById(R.id.css_rl_bottom_bar);
        backBtn = findViewById(R.id.css_title_back);
        backBtn.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        if (type == Constants.PREVIEW_TYPE_SELECT) {
            confirmTv.setVisibility(View.VISIBLE);
            bottomBarRl.setVisibility(View.VISIBLE);
            StringBuilder sb = new StringBuilder();
            sb.append(getString(R.string.css_string_finish)).append(selectImages.size())
                    .append("/").append(maxNum).append(")");
            confirmTv.setText(sb.toString());
            selectTv.setVisibility(View.VISIBLE);
        } else if (type == Constants.PREVIEW_TYPE_VIEW) {
            bottomBarRl.setVisibility(View.GONE);
            confirmTv.setVisibility(View.GONE);
            selectTv.setVisibility(View.GONE);
        }

        confirmTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                if (type == Constants.PREVIEW_TYPE_SELECT) {
                    isConfirm = true;
                    finish();
                }
            }
        });
        indicatorTv.setText(position + 1 + "/" + mImages.size());

        selectTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                clickSelect();
            }
        });

        ImagePagerAdapter adapter = new ImagePagerAdapter(this, mImages);
        viewPager.setAdapter(adapter);
//        adapter.setOnItemClickListener(new ImagePagerAdapter.OnItemClickListener() {
//            @Override
//            public void onGridItemClick(int position, ImageItem image) {
//
//            }
//        });
        viewPager.setCurrentItem(position);
        changeSelect(mImages.get(position));
        viewPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener() {
            @Override
            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            @Override
            public void onPageSelected(int position) {
                indicatorTv.setText(position + 1 + "/" + mImages.size());
                changeSelect(mImages.get(position));
            }

            @Override
            public void onPageScrollStateChanged(int state) {
            }
        });
    }

    private void changeSelect(String image) {
        if (type == Constants.PREVIEW_TYPE_SELECT) {
            selectTv.setSelected(selectImages.contains(image));
            setSelectImageCount(selectImages.size());
        }
    }

    private void setSelectImageCount(int count) {
        if (count == 0) {
            confirmTv.setEnabled(false);
            StringBuilder sb = new StringBuilder();
            sb.append(getString(R.string.css_string_finish)).append("(0/").append(maxNum).append(")");
            confirmTv.setText(sb.toString());
        } else {
            confirmTv.setEnabled(true);
            if (maxNum > 0) {
                StringBuilder sb = new StringBuilder();
                sb.append(getString(R.string.css_string_finish)).append("(").append(count)
                        .append("/").append(maxNum).append(")");
                confirmTv.setText(sb.toString());
            } else {
                StringBuilder sb = new StringBuilder();
                sb.append(getString(R.string.css_string_finish)).append("(").append(count).append(")");
                confirmTv.setText(sb.toString());
            }
        }
    }

    private void clickSelect() {
        int position = viewPager.getCurrentItem();
        if (mImages != null && mImages.size() > position) {
            String image = mImages.get(position);
            if (selectImages.contains(image)) {
                selectImages.remove(image);
            } else if (selectImages.size() < maxNum) {
                selectImages.add(image);
            }else {
                StringBuilder sb = new StringBuilder();
                sb.append(getString(R.string.css_string_chose_at_most)).append(" ").append(maxNum).append(" ").append(getString(R.string.css_string_sheet));
                ToastUtil.showToastTip(getApplicationContext(), sb.toString(), false);
            }
            changeSelect(image);
        }
    }

    @Override
    public void finish() {
        if (type == Constants.PREVIEW_TYPE_SELECT) {
            Intent intent = new Intent();
            intent.putExtra(Constants.KEY_IS_CONFIRM, isConfirm);
            intent.putExtra(Constants.KEY_SELECTED_PICS, selectImages);
            setResult(Constants.PREVIEW_RESULT_CODE, intent);
        }
        super.finish();
    }
}
