package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.utils.ToastHelper;
import com.css.sdk.cservice.view.CssRoundBtn;

import static com.css.sdk.cservice.base.Constants.KEY_DETIAL_EVALUATE_RESULT;
import static com.css.sdk.cservice.base.Constants.REQUESTCODE_SUBMITSUCCESS_FQADETAIL;

public class FaqDetailActvity extends AbstractBaseActivity {
    private String recommendId;
    private TextView answerTv;
    private CssRoundBtn unsolve;
    private CssRoundBtn solve;
    private LinearLayout loadingLl;
    private TextView bottomHintTv;
    private FaqDetail detail;
    private RelativeLayout bottomBtnLl;
    private String faqName;
    private String quId = "";


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    protected void initExtraData() {
        recommendId = getIntent().getStringExtra(Constants.KEY_RECOMMEND_ID);
        faqName = getIntent().getStringExtra(Constants.KEY_RECOMMEND_NAME);
        quId = getIntent().getStringExtra(Constants.KEY_QU_ID);
    }

    @Override
    public int getLayoutId() {
        return R.layout.css_activity_faq_detail_actvity;
    }

    @Override
    public void initView() {
        showTitleClose(true);
        if (faqName.length()>=60){
            String substring = faqName.substring(0, 60);
            faqName=substring+"\n"+faqName.substring(60,faqName.length());
        }
        showTitleName(true, faqName);

        answerTv = findViewById(R.id.css_answer);
        answerTv.setVisibility(View.GONE);
        unsolve = findViewById(R.id.css_rl_unsolveqa);
        bottomHintTv = findViewById(R.id.css_hint);
        bottomBtnLl = findViewById(R.id.css_bottom_rl);
        bottomBtnLl.setVisibility(View.GONE);
        unsolve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(false);
            }
        });
        solve = findViewById(R.id.css_rl_solveqa);
        solve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                evaluate(true);
            }
        });
        loadingLl = findViewById(R.id.css_loading_layout);

    }

    @Override
    public void initData() {
        requestData();
    }

    private void showLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (!loadingLl.isShown()) {
                    loadingLl.setVisibility(View.VISIBLE);
                }
            }
        });
    }

    private void hideLoading() {
        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                if (loadingLl.isShown()) {
                    loadingLl.setVisibility(View.GONE);
                }
            }
        });
    }

    private void evaluate(boolean isHelp) {
        showLoading();
        BusinessRequest.evaluateFqa(recommendId, isHelp, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (isHelp) {
                            bottomHintTv.setText(R.string.css_string_thanks_for_evaluate);
                            bottomBtnLl.setVisibility(View.GONE);
                            if (TextUtils.isEmpty(quId)) {
                                ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                            } else {
                                backToSubmitSuccess(isHelp);
                            }
                            finish();
                        } else {
                            if (TextUtils.isEmpty(quId)) {
                                bottomHintTv.setText(R.string.css_text_hint_nohelp);
                                bottomBtnLl.setVisibility(View.VISIBLE);
                                solve.setVisibility(View.GONE);
                                showFeedback();
                            } else {
                                ToastHelper.showShortToastCenter(getResources().getString(R.string.css_string_thanks_for_evaluate));
                                finish();
                            }
                        }

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void showFeedback() {
        unsolve.setBackground(getResources().getDrawable(R.drawable.css_shape_rounded_bg_whitesolied_blueline));
        unsolve.setText(getResources().getString(R.string.css_string_feedback_new));
        unsolve.changeTextColor(getResources().getColor(R.color.css_default_blue));
        unsolve.setImgVisible(View.GONE);
        unsolve.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                Intent intent = new Intent(FaqDetailActvity.this, FeedBackActivity.class);
                startActivity(intent);
                finish();
            }
        });
    }

    private void backToSubmitSuccess(boolean isHelp) {
        Intent intent = new Intent(FaqDetailActvity.this, SubmitSuccessActivity.class);
        intent.putExtra(KEY_DETIAL_EVALUATE_RESULT, isHelp);
        FaqDetailActvity.this.setResult(REQUESTCODE_SUBMITSUCCESS_FQADETAIL, intent);
    }

    private void requestData() {
        showLoading();
        BusinessRequest.getFaqDetail(this, recommendId, new RequestCallback<FaqDetail>() {
            @Override
            public void onSuccess(final FaqDetail result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        detail = result;
                        if (!TextUtils.isEmpty(detail.answer)) {
                            answerTv.setText(detail.answer);
                            answerTv.setVisibility(View.VISIBLE);
                            bottomBtnLl.setVisibility(View.VISIBLE);
                        } else {
                            answerTv.setVisibility(View.GONE);
                        }
                    }
                });
            }

            @Override
            public void onFail(final String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

}
