/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.CpuUtils;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import org.json.JSONException;
import org.json.JSONObject;

public class DeviceInfoHelper {
    public static int getScreenWidth(Context context) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((Activity)context).getWindowManager().getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.heightPixels - DeviceInfoHelper.getStatusBarHeight(context);
    }

    public static int getStatusBarHeight(Context context) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0;
        int statusBarHeight = 0;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(x);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return statusBarHeight;
    }

    public static String getAppVersion(Context ctx) {
        PackageManager manager = ctx.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(ctx.getPackageName(), 0);
            return String.valueOf(info.versionCode);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getLocalLanguage(Context context) {
        String language = "en";
        try {
            language = context.getResources().getConfiguration().locale.toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return language;
    }

    public boolean isTabletDevice(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static int getScreenType(Context context) {
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), context.getClass().getName());
            ActivityInfo info = context.getPackageManager().getActivityInfo(componentName, 1);
            if (info.screenOrientation == 6) {
                int angle = ((WindowManager)context.getSystemService("window")).getDefaultDisplay().getRotation();
                if (angle == 1) {
                    return Constants.SCREEN_TYPE_LAND;
                }
                if (angle == 3) {
                    return Constants.SCREEN_TYPE_REVERSE_LAND;
                }
            } else {
                if (info.screenOrientation == 0) {
                    return Constants.SCREEN_TYPE_LAND;
                }
                if (info.screenOrientation == 1) {
                    return Constants.SCREEN_TYPE_PORT;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return -1;
    }

    public static boolean isSensorLand(Context context) {
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), context.getClass().getName());
            ActivityInfo info = context.getPackageManager().getActivityInfo(componentName, 1);
            if (info.screenOrientation == 6) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public static String getBuildModel() {
        return Build.MODEL;
    }

    public static String getSystemVersion() {
        return Build.VERSION.SDK_INT + "";
    }

    public static String getCpuInfo() {
        JSONObject json = new JSONObject();
        try {
            json.put("cpu_num", CpuUtils.getNumCpuCores());
            json.put("cpu_abi", (Object)CpuUtils.getCpuAbi());
            json.put("hardware", (Object)CpuUtils.getCpuHardware());
            json.put("max_freq", CpuUtils.getCpuMaxFreq());
            json.put("min_freq", CpuUtils.getCpuMinFreq());
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return json.toString();
    }

    public static String getNetWorkType(Context ctx) {
        try {
            ConnectivityManager connectMgr = (ConnectivityManager)ctx.getSystemService("connectivity");
            NetworkInfo info = connectMgr.getActiveNetworkInfo();
            if (info == null) {
                return "none";
            }
            if (info.getType() == 1) {
                return "wifi";
            }
            if (info.getType() == 0) {
                return "mobile";
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unkown";
    }

    public static String getAvailMemory(Context context) {
        ActivityManager am = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        return String.valueOf(mi.availMem / 1024L / 1024L / 1024L).trim() + "GB";
    }

    public static String getTotalMemory(Context context) {
        String str1 = "/proc/meminfo";
        long initial_memory = 0L;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(localFileReader, 8192);
            String str2 = localBufferedReader.readLine();
            if (TextUtils.isEmpty((CharSequence)str2)) {
                return "";
            }
            if (!str2.contains("\\s+")) {
                return "";
            }
            String[] arrayOfString = str2.split("\\s+");
            initial_memory = Integer.valueOf(arrayOfString[1]) / 1024 / 1024;
            localBufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return String.valueOf(initial_memory) + "GB";
    }
}

