/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.BitmapFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;
import com.css.sdk.R;
import com.css.sdk.cservice.activity.SelectPictureActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.imageloader.ImageLoader;
import com.css.sdk.cservice.listener.ItemDeleteCallback;
import java.util.ArrayList;

public class AlbumPicAdapter
extends BaseAdapter {
    private Activity mActivity;
    private ArrayList<String> selectedPictures = new ArrayList();
    private LayoutInflater layoutInflater;
    private static final int REQUEST_PICK = 0;
    private ItemDeleteCallback deleteCallback;

    public AlbumPicAdapter(Activity activity) {
        this.mActivity = activity;
        this.layoutInflater = LayoutInflater.from((Context)activity);
    }

    public void addData(ArrayList<String> selectedPictures) {
        this.selectedPictures.addAll(selectedPictures);
    }

    public ArrayList<String> getSelectPictures() {
        return this.selectedPictures;
    }

    public void clear() {
        this.selectedPictures.clear();
    }

    public int getCount() {
        return this.selectedPictures.size() + 1;
    }

    public Object getItem(int position) {
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = new ViewHolder();
        convertView = this.layoutInflater.inflate(R.layout.css_grid_addpic_item, null);
        holder.image = (ImageView)convertView.findViewById(R.id.child_iv);
        holder.delete = (Button)convertView.findViewById(R.id.css_delete);
        if (position == this.selectedPictures.size()) {
            holder.delete.setVisibility(8);
            holder.image.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    AlbumPicAdapter.this.selectClick();
                }
            });
            holder.image.setImageBitmap(BitmapFactory.decodeResource((Resources)this.mActivity.getResources(), (int)R.drawable.css_icon_add_pic));
            if (position == 3) {
                holder.image.setVisibility(8);
            }
        } else {
            holder.delete.setVisibility(0);
            ImageLoader.getInstance().load(this.selectedPictures.get(position), holder.image);
            holder.delete.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (AlbumPicAdapter.this.deleteCallback != null) {
                        AlbumPicAdapter.this.deleteCallback.onDeleted((String)AlbumPicAdapter.this.selectedPictures.get(position));
                    }
                    AlbumPicAdapter.this.selectedPictures.remove(position);
                    AlbumPicAdapter.this.notifyDataSetChanged();
                }
            });
        }
        return convertView;
    }

    private void selectClick() {
        Intent intent = new Intent();
        intent.setClass((Context)this.mActivity, SelectPictureActivity.class);
        intent.putExtra(Constants.KEY_SELECTED_PIC_NUM, this.selectedPictures.size());
        if (this.selectedPictures.size() < 3) {
            this.mActivity.startActivityForResult(intent, 0);
        }
    }

    public void setDeleteCallback(ItemDeleteCallback deleteCallback) {
        this.deleteCallback = deleteCallback;
    }

    public class ViewHolder {
        public ImageView image;
        public Button delete;
    }
}

