package com.css.sdk.cservice.utils;

import java.util.HashMap;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ContactValidator {
    private static HashMap<String, String> phones = new HashMap<String, String>() {{
        put("zh-CN", "^(\\+?0?86\\-?)?[1-2][0-9]{10}$");
        put("zh-TW","^(\\+?886\\-?|0)?9\\d{8}$");
        put("vi-VN","^(\\+?84|0)?((1(2([0-9])|6([2-9])|88|99))|(9((?!5)[0-9])))([0-9]{7})$");
        put("tr-TR","^(\\+?90|0)?5\\d{9}$");
        put("sr-RS","^(\\+3816|06)[- \\d]{5,9}$");
        put("ru-RU","^(\\+?7|8)?9\\d{9}$");
        put("pt-PT","^(\\+?351)?9[1236]\\d{7}$");
        put("pt-BR","^(\\+?55|0)\\-?[1-9]{2}\\-?[2-9]{1}\\d{3,4}\\-?\\d{4}$");
        put("pl-PL","^(\\+?48)? ?[5-8]\\d ?\\d{3} ?\\d{2} ?\\d{2}$");
        put("nn-NO","^(\\+?47)?[49]\\d{7}$");
        put("nl-BE","^(\\+?32|0)4?\\d{8}$");
        put("nb-NO","^(\\+?47)?[49]\\d{7}$");
        put("ms-MY","^(\\+?6?01){1}(([145]{1}(\\-|\\s)?\\d{7,8})|([236789]{1}(\\s|\\-)?\\d{7}))$");
        put("ja-JP","^(\\+?81|0)\\d{1,4}[ \\-]?\\d{1,4}[ \\-]?\\d{4}$");
        put("it-IT","^(\\+?39)?\\s?3\\d{2} ?\\d{6,7}$");
        put("hu-HU","^(\\+?36)(20|30|70)\\d{7}$");
        put("he-IL","^(\\+972|0)([23489]|5[0248]|77)[1-9]\\d{6}");
        put("fr-FR","^(\\+?33|0)[67]\\d{8}$");
        put("fi-FI","^(\\+?358|0)\\s?(4(0|1|2|4|5)?|50)\\s?(\\d\\s?){4,8}\\d$");
        put("es-ES","^(\\+?34)?(6\\d{1}|7[1234])\\d{7}$");
        put("en-ZM","^(\\+?26)?09[567]\\d{7}$");
        put("en-ZA","^(\\+?27|0)\\d{9}$");
        put("en-NZ","^(\\+?64|0)2\\d{7,9}$");
        put("en-IN","^(\\+?91|0)?[789]\\d{9}$");
        put("en-HK","^(\\+?852\\-?)?[569]\\d{3}\\-?\\d{4}$");
        put("en-GB","^(\\+?44|0)7\\d{9}$");
        put("en-AU","^(\\+?61|0)4\\d{8}$");
        put("el-GR","^(\\+?30)?(69\\d{8})$");
        put("da-DK","^(\\+?45)?(\\d{8})$");
        put("de-DE","^(\\+?49[ \\.\\-])?([\\(]{1}[0-9]{1,6}[\\)])?([0-9 \\.\\-\\/]{3,20})((x|ext|extension)[ ]?[0-9]{1,4})?$");
        put("cs-CZ","^(\\+?420)? ?[1-9][0-9]{2} ?[0-9]{3} ?[0-9]{3}$");
        put("en-US","^(\\+?1)?[2-9]\\d{2}[2-9](?!11)\\d{6}$");
        put("ar-SA","^(!?(\\+?966)|0)?5\\d{8}$");
        put("ar-SY","^(!?(\\+?963)|0)?9\\d{8}$");
        put("ar-DZ","^(\\+?213|0)(5|6|7)\\d{8}$");
    }};

    //判断是否为手机号
    public static boolean isMobilePhone(String mobile) {
        StringBuilder sb = new StringBuilder();
        sb.append(Locale.getDefault().getLanguage()).append("-").append(Locale.getDefault().getCountry());
        String regex = phones.get(sb.toString());
        if (regex != null) {
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(mobile);
            return m.matches();
        }
        return true;
    }

    private static boolean isEmail(String email) {
        Pattern p = Pattern.compile("^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\\.[a-zA-Z0-9_-]+)+$");
        Matcher m = p.matcher(email);
        return m.matches();
    }

    public static boolean checkContact(String contact) {
        if (isEmail(contact) || isMobilePhone(contact)) {
            return true;
        } else {
            return false;
        }
    }
}
