package com.css.sdk.cservice.activity;

import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.design.widget.TabLayout;
import android.util.TypedValue;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;

import java.util.List;

public abstract class AbstractBaseActivity extends BaseActivity {

    protected abstract void initExtraData();

    public abstract int getLayoutId();

    public abstract void initView();

    public abstract void initData();

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        initExtraData();
        setContentView(getLayoutId());
        initView();
        initData();
    }

    /**
     * 显示左边的返回按钮，默认是finish当前activity，需要的话可以重写
     * @param show
     */
    public void showTitleBack(boolean show) {
        RelativeLayout titleBack = findViewById(R.id.css_title_back);
        titleBack.setVisibility(show ? View.VISIBLE : View.GONE);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }


    protected void showTitleClose(boolean show) {
        RelativeLayout closeRoot = findViewById(R.id.css_title_close);
        closeRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        closeRoot.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
    }

    protected void showTitleName(boolean show, String name) {
        RelativeLayout titleTvRoot = findViewById(R.id.rl_titile_text);
        titleTvRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        if (!show) {
            return;
        }
        TextView titleTv = findViewById(R.id.css_title_tv);
        titleTv.setText(name);
    }

    protected void showTitleLargeSearch(boolean show) {
        LinearLayout largeSeachRoot = findViewById(R.id.rl_title_largesearch);
        largeSeachRoot.setVisibility(show ? View.VISIBLE : View.GONE);
    }

    protected View showTitleShortSearch(boolean show) {
        LinearLayout searchRoot = findViewById(R.id.rl_title_shortsearch);
        searchRoot.setVisibility(show ? View.VISIBLE : View.GONE);
        return searchRoot;
    }

    protected void showTitleTab(boolean show, List<String> tags, TabLayout.BaseOnTabSelectedListener listener) {
        RelativeLayout tabLayout = findViewById(R.id.rl_titile_tab);
        tabLayout.setVisibility(show ? View.VISIBLE : View.GONE);
        if (!show) {
            return;
        }

        TabLayout mTabLayout = findViewById(R.id.css_title_tab_layout);
        // 添加 tab item
        for (String tag : tags) {
            mTabLayout.addTab(mTabLayout.newTab().setText(tag));
        }
        mTabLayout.addOnTabSelectedListener(listener);
    }

    protected void goActvityForResult(Context clz, Class targetClz, int requestCode) {
        Intent intent = new Intent(clz, targetClz);
        startActivityForResult(intent, requestCode);
    }

    /**
     * dp转px
     */
    protected int dp2px(Context context, float dpValue) {
        return (int) TypedValue.applyDimension(TypedValue.COMPLEX_UNIT_DIP, dpValue, context.getResources().getDisplayMetrics());
    }

    protected Point getScreenMsg(Context context) {
        Point point = new Point();
        WindowManager wm = (WindowManager) context
                .getSystemService(Context.WINDOW_SERVICE);
        wm.getDefaultDisplay().getSize(point);
        return point;
    }
}
