/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.utils;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import android.view.WindowManager;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.utils.RomUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public class CutoutUtil {
    private static final int FLAG_NOTCH_SUPPORT = 65536;
    private static final int VIVO_NOTCH = 32;
    private static final int VIVO_FILLET = 8;

    public static boolean hasNotchScreen(Activity activity) {
        return CutoutUtil.isAndroidP(activity) || CutoutUtil.isNotchMi() || CutoutUtil.hasNotchOppo(activity) || CutoutUtil.hasNotchHuawei((Context)activity);
    }

    public static void useNotch(Activity activity, int screenType) {
        if (Build.VERSION.SDK_INT >= 28) {
            activity.getWindow().getDecorView().setSystemUiVisibility(1028);
            WindowManager.LayoutParams lp = activity.getWindow().getAttributes();
            lp.layoutInDisplayCutoutMode = 1;
            activity.getWindow().setAttributes(lp);
            CutoutUtil.getNotchParams(activity, screenType);
            return;
        }
        if (Build.VERSION.SDK_INT >= 26) {
            if (RomUtil.isMiui()) {
                int padding = CutoutUtil.getNotchHeight((Context)activity);
                if (padding > 0) {
                    CutoutUtil.setDisplayInNotchMi(activity);
                    if (screenType == Constants.SCREEN_TYPE_LAND) {
                        activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(padding, 0, 0, 0);
                    } else {
                        activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, padding, 0);
                    }
                }
                return;
            }
            if (RomUtil.isOppo()) {
                if (screenType == Constants.SCREEN_TYPE_LAND) {
                    activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(CutoutUtil.getScreenValue(), 0, 0, 0);
                } else {
                    activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, 0, 0);
                }
                return;
            }
            if (RomUtil.isVivo()) {
                return;
            }
            if (RomUtil.isEmui()) {
                CutoutUtil.setFullScreenWindowLayoutInDisplayCutoutHuawei(activity.getWindow());
                if (screenType == Constants.SCREEN_TYPE_LAND) {
                    activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(CutoutUtil.getNotchSize((Context)activity)[1], 0, 0, 0);
                }
                if (screenType == Constants.SCREEN_TYPE_REVERSE_LAND) {
                    activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, 0, 0);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int[] getNotchSize(Context context) {
        int[] ret = new int[]{0, 0};
        try {
            ClassLoader cl = context.getClassLoader();
            Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
            Method get = HwNotchSizeUtil.getMethod("getNotchSize", new Class[0]);
            ret = (int[])get.invoke(HwNotchSizeUtil, new Object[0]);
            return ret;
        }
        catch (ClassNotFoundException classNotFoundException) {}
        catch (NoSuchMethodException noSuchMethodException) {}
        catch (Exception exception) {}
        finally {
            return ret;
        }
    }

    @TargetApi(value=28)
    private static void getNotchParams(final Activity activity, final int screenType) {
        final View decorView = activity.getWindow().getDecorView();
        decorView.post(new Runnable(){

            @Override
            public void run() {
                DisplayCutout displayCutout;
                WindowInsets insets = decorView.getRootWindowInsets();
                if (insets != null && (displayCutout = insets.getDisplayCutout()) != null) {
                    List rects = displayCutout.getBoundingRects();
                    int pading = 0;
                    if (rects != null && rects.size() != 0) {
                        for (Rect rect : rects) {
                            pading = Math.abs(rect.right - rect.left);
                        }
                    }
                    if (pading != 0) {
                        if (screenType == Constants.SCREEN_TYPE_LAND) {
                            activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(pading, 0, 0, 0);
                        } else {
                            activity.getWindow().getDecorView().findViewById(0x1020002).setPadding(0, 0, 0, 0);
                        }
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNotchHuawei(Context context) {
        boolean ret = false;
        if (RomUtil.isEmui()) {
            try {
                ClassLoader cl = context.getClassLoader();
                Class<?> HwNotchSizeUtil = cl.loadClass("com.huawei.android.util.HwNotchSizeUtil");
                Method get = HwNotchSizeUtil.getMethod("hasNotchInScreen", new Class[0]);
                ret = (Boolean)get.invoke(HwNotchSizeUtil, new Object[0]);
                return ret;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            catch (NoSuchMethodException noSuchMethodException) {}
            catch (Exception exception) {}
            finally {
                return ret;
            }
        }
        return ret;
    }

    private static void setFullScreenWindowLayoutInDisplayCutoutHuawei(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("addHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void clearDisplayCutoutHuawei(Window window) {
        if (window == null) {
            return;
        }
        WindowManager.LayoutParams layoutParams = window.getAttributes();
        try {
            Class<?> layoutParamsExCls = Class.forName("com.huawei.android.view.LayoutParamsEx");
            Constructor<?> con = layoutParamsExCls.getConstructor(WindowManager.LayoutParams.class);
            Object layoutParamsExObj = con.newInstance(layoutParams);
            Method method = layoutParamsExCls.getMethod("clearHwFlags", Integer.TYPE);
            method.invoke(layoutParamsExObj, 65536);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean hasNotchOppo(Activity activity) {
        boolean ret = false;
        if (RomUtil.isOppo()) {
            try {
                ret = activity.getPackageManager().hasSystemFeature("com.oppo.feature.screen.heteromorphism");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return ret;
    }

    private static int getScreenValue() {
        int padding = 0;
        String value = "";
        try {
            String[] str;
            Class<?> cls = Class.forName("android.os.SystemProperties");
            Method get = cls.getMethod("get", String.class);
            Object object = cls.newInstance();
            value = (String)get.invoke(object, "ro.oppo.screen.heteromorphism");
            if (!TextUtils.isEmpty((CharSequence)value) && value.indexOf(":") > -1 && (str = value.split(":")).length == 2) {
                String[] leftP = str[0].split(",");
                int left = Integer.valueOf(leftP[1]);
                String[] rightP = str[1].split(",");
                int right = Integer.valueOf(rightP[1]);
                padding = Math.abs(right - left);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return padding;
    }

    private static boolean isAndroidP(Activity activity) {
        WindowInsets windowInsets;
        View decorView = activity.getWindow().getDecorView();
        return decorView != null && Build.VERSION.SDK_INT >= 28 && (windowInsets = decorView.getRootWindowInsets()) != null && windowInsets.getDisplayCutout() != null;
    }

    private static boolean isNotchMi() {
        if (RomUtil.isMiui()) {
            try {
                Method getInt = Class.forName("android.os.SystemProperties").getMethod("getInt", String.class, Integer.TYPE);
                int notch = (Integer)getInt.invoke(null, "ro.miui.notch", 0);
                return notch == 1;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    private static void setDisplayInNotchMi(Activity activity) {
        int flag = 1792;
        try {
            Method method = Window.class.getMethod("addExtraFlags", Integer.TYPE);
            method.invoke((Object)activity.getWindow(), flag);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static int getNotchHeight(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_height", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    private static int getNotchWidth(Context context) {
        int resourceId = context.getResources().getIdentifier("notch_width", "dimen", "android");
        if (resourceId > 0) {
            return context.getResources().getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean hasNotchVivo(Context context) {
        boolean ret = false;
        if (RomUtil.isVivo()) {
            try {
                ClassLoader classLoader = context.getClassLoader();
                Class<?> FtFeature = classLoader.loadClass("android.util.FtFeature");
                Method method = FtFeature.getMethod("isFeatureSupport", Integer.TYPE);
                ret = (Boolean)method.invoke(FtFeature, 32);
                return ret;
            }
            catch (ClassNotFoundException classNotFoundException) {}
            catch (NoSuchMethodException noSuchMethodException) {}
            catch (Exception exception) {}
            finally {
                return ret;
            }
        }
        return ret;
    }
}

