/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.request;

import android.text.TextUtils;
import com.css.sdk.cservice.base.http.HttpClient;
import com.css.sdk.cservice.base.http.HttpsClient;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.base.utils.Utils;
import com.css.sdk.cservice.request.HttpCallback;
import com.css.sdk.cservice.request.HttpThread;
import com.css.sdk.cservice.request.RunWrapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class HttpDnsManager {
    private static final Pattern IP_REG = Pattern.compile("(\\d*)\\.(\\d*)\\.(\\d*)\\.(\\d*)");
    private static final long DNS_IP_CACHE_MILLS = 600000L;
    private static String sDnsDomain;
    private static long sLastCallDnsMills;
    private static ArrayList<String> sDnsServerList;
    private static HashMap<String, HashSet<String>> sDnsMap;

    public static HashMap<String, HashSet<String>> getDnsMap() {
        return sDnsMap;
    }

    public static String getUrlDomain() {
        return sDnsDomain;
    }

    public static void addDnsMappingServers(String domain, String dns) {
        sDnsDomain = domain;
        sDnsServerList = new ArrayList();
        sDnsServerList.add(dns);
    }

    public static void addDnsMappingServers(String domain, ArrayList<String> dnsServerList) {
        sDnsDomain = domain;
        sDnsServerList = Utils.getShuffleList(dnsServerList);
    }

    public static void callForClientDnsIp(final HttpCallback<String> callback) {
        if (sDnsMap.containsKey(sDnsDomain) && System.currentTimeMillis() - sLastCallDnsMills <= 600000L) {
            callback.onResponseSuccess("");
        } else {
            if (sDnsMap != null && sDnsMap.containsKey(sDnsDomain)) {
                sDnsMap.remove(sDnsDomain);
            }
            RunWrapper runnable = new RunWrapper(new Runnable(){

                @Override
                public void run() {
                    HttpDnsManager.callForClientDnsIp(sDnsDomain, 0, callback);
                }
            });
            HttpThread.execute(runnable);
        }
    }

    private static void callForClientDnsIp(String domain, int currentIndex, HttpCallback<String> callback) {
        boolean ipFound = false;
        String dnsUrl = sDnsServerList.get(currentIndex);
        LogUtils.i("HttpDnsManager callForClientDnsIp dnsUrl is " + dnsUrl);
        try {
            JSONArray array;
            JSONObject json;
            String body = "";
            body = dnsUrl.startsWith("http://") ? HttpClient.builder().setUrl(dnsUrl).request().getBody() : HttpsClient.builder().setmHostName("").setUrl(dnsUrl).request().getBody();
            if (!TextUtils.isEmpty((CharSequence)body) && (json = new JSONObject(body)).has("answer") && (array = json.getJSONArray("answer")) != null && array.length() > 0) {
                for (int i = 0; i < array.length(); ++i) {
                    String ip;
                    Matcher matcher;
                    JSONObject item = array.optJSONObject(i);
                    String type = item.optString("type");
                    if (!"A".equals(type) || !(matcher = IP_REG.matcher(ip = item.optString("rdata"))).matches()) continue;
                    HttpDnsManager.addToDnsMap(domain, ip);
                    ipFound = true;
                }
            }
            if (!ipFound) {
                HttpDnsManager.callNextDnsServer(domain, currentIndex, callback);
            } else {
                sLastCallDnsMills = System.currentTimeMillis();
                callback.onResponseSuccess("");
            }
        }
        catch (Throwable e) {
            LogUtils.w("HttpDnsManager callForClientDnsIp error: ", e);
            if (!ipFound) {
                HttpDnsManager.callNextDnsServer(domain, currentIndex, callback);
            }
            sLastCallDnsMills = System.currentTimeMillis();
            callback.onResponseSuccess("");
        }
    }

    private static void callNextDnsServer(String domain, int index, HttpCallback<String> callback) {
        if (++index < sDnsServerList.size()) {
            HttpDnsManager.callForClientDnsIp(domain, index, callback);
        } else {
            callback.onResponedFail(new Exception("HttpDnsManager callForClientDnsIp failed "), -1);
        }
    }

    private static void addToDnsMap(String domain, String ip) {
        if (sDnsMap == null) {
            sDnsMap = new HashMap();
        }
        LogUtils.i("HttpDnsManager addToDnsMap " + domain + " mapping " + ip);
        HashSet<Object> ipSet = new HashSet();
        if (sDnsMap.containsKey(domain)) {
            ipSet = sDnsMap.get(domain);
        } else {
            sDnsMap.put(domain, ipSet);
        }
        ipSet.add(ip);
    }

    static {
        sDnsServerList = new ArrayList();
        sDnsMap = new HashMap();
    }
}

