/*
 * Decompiled with CFR 0.152.
 */
package com.css.sdk.cservice.base.http;

import android.text.TextUtils;
import com.css.sdk.cservice.base.http.HttpResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpsClient {
    public static final String METHOD_GET = "GET";
    public static final String METHOD_HEAD = "HEAD";
    public static final String METHOD_POST = "POST";
    private URL url;
    private int connectTimeout = 10000;
    private int readTimeout = 15000;
    private boolean useCaches = false;
    private boolean redirected = false;
    private String requestMethod = "GET";
    private String requestBody = null;
    private String userAgent = null;
    private String enctyType = null;
    private Map<String, String> headerMap = new ConcurrentHashMap<String, String>();
    private HttpsURLConnection conn;
    private String mHostName;
    private String webUrl;

    public static HttpsClient builder() {
        return new HttpsClient();
    }

    private HttpsClient() {
    }

    public HttpsClient setUrl(String url) throws MalformedURLException {
        this.url = new URL(url);
        this.webUrl = url;
        return this;
    }

    public HttpsClient setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        return this;
    }

    public HttpsClient setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        return this;
    }

    public HttpsClient setUseCaches(boolean use) {
        this.useCaches = use;
        return this;
    }

    public HttpsClient setRequestMethod(String method) {
        this.requestMethod = method;
        return this;
    }

    public HttpsClient setRequestHeader(String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)key) && value != null) {
            this.headerMap.put(key, value);
        }
        return this;
    }

    public HttpsClient setRequestBody(String body) {
        this.requestBody = body;
        return this;
    }

    public HttpsClient setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public HttpsClient setEnctyType(String enctyType) {
        this.enctyType = enctyType;
        return this;
    }

    public HttpResponse request() throws Exception {
        if (this.url == null) {
            throw new IOException("URL is empty");
        }
        this.makeConnection();
        return new HttpResponse(this.conn);
    }

    public HttpsClient setmHostName(String mHostName) {
        this.mHostName = mHostName;
        return this;
    }

    private void makeConnection() throws Exception {
        try {
            this.conn = (HttpsURLConnection)this.url.openConnection();
            this.conn.setConnectTimeout(this.connectTimeout);
            this.conn.setReadTimeout(this.readTimeout);
            this.conn.setUseCaches(this.useCaches);
            this.conn.setRequestMethod(this.requestMethod);
            this.conn.setInstanceFollowRedirects(true);
            if (this.userAgent != null) {
                this.conn.setRequestProperty("User-Agent", this.userAgent);
            }
            if (this.headerMap != null && !this.headerMap.isEmpty()) {
                for (Map.Entry<String, String> entry : this.headerMap.entrySet()) {
                    this.conn.setRequestProperty(entry.getKey(), this.headerMap.get(entry.getKey()));
                }
            }
            if (METHOD_GET.equals(this.requestMethod) || METHOD_HEAD.equals(this.requestMethod)) {
                this.conn.setDoOutput(false);
            } else if (METHOD_POST.equals(this.requestMethod)) {
                this.conn.setDoOutput(true);
            }
            if (this.mHostName != null) {
                this.conn.setRequestProperty("Host", this.mHostName);
            }
            this.trustAllCertificate(this.conn);
            if (this.requestBody != null) {
                if (this.enctyType != null) {
                    this.conn.setRequestProperty("Content-type", this.enctyType);
                } else {
                    this.conn.setRequestProperty("Content-type", "application/json;charset=UTF-8");
                }
                OutputStream os = this.conn.getOutputStream();
                byte[] bytes = this.requestBody.getBytes("UTF-8");
                os.write(bytes);
                os.close();
            }
            if (this.conn.getResponseCode() >= 300 && this.conn.getResponseCode() < 400) {
                String location = this.conn.getHeaderField("Location");
                if (TextUtils.isEmpty((CharSequence)location)) {
                    location = this.conn.getHeaderField("location");
                }
                if (!this.redirected && !TextUtils.isEmpty((CharSequence)location)) {
                    this.redirected = true;
                    this.setUrl(location);
                    this.makeConnection();
                }
            }
        }
        catch (Throwable e) {
            throw new Exception(e);
        }
    }

    public void trustAllCertificate(HttpsURLConnection http) throws Exception {
        try {
            TrustManager[] tm = new TrustManager[]{new MyX509TrustManager()};
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, tm, new SecureRandom());
            SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
            http.setHostnameVerifier(new TrustAnyHostnameVerifier());
            http.setSSLSocketFactory(sslSocketFactory);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static class MyX509TrustManager
    implements X509TrustManager {
        private MyX509TrustManager() {
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return null;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustAnyHostnameVerifier
    implements HostnameVerifier {
        private TrustAnyHostnameVerifier() {
        }

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    }
}

