package com.css.sdk.cservice.base.utils;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.text.TextUtils;
import android.text.format.Formatter;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.Surface;
import android.view.WindowManager;

import com.css.sdk.cservice.base.Constants;

import org.json.JSONException;
import org.json.JSONObject;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Locale;

/**
 * Copid by Roy on 2019/2/22.
 */

public class DeviceInfoHelper {

    public static int getScreenWidth(Context context) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((Activity) context).getWindowManager().getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.widthPixels;
    }

    public static int getScreenHeight(Context context) {
        DisplayMetrics localDisplayMetrics = new DisplayMetrics();
        ((Activity) context).getWindowManager().getDefaultDisplay().getMetrics(localDisplayMetrics);
        return localDisplayMetrics.heightPixels - getStatusBarHeight(context);
    }

    public static int getStatusBarHeight(Context context) {
        Class<?> c = null;
        Object obj = null;
        Field field = null;
        int x = 0, statusBarHeight = 0;
        try {
            c = Class.forName("com.android.internal.R$dimen");
            obj = c.newInstance();
            field = c.getField("status_bar_height");
            x = Integer.parseInt(field.get(obj).toString());
            statusBarHeight = context.getResources().getDimensionPixelSize(x);
        } catch (Exception e1) {
            e1.printStackTrace();
        }
        return statusBarHeight;
    }

    //获取apk的版本号 currentVersionCode
    public static String getAppVersion(Context ctx) {
        PackageManager manager = ctx.getPackageManager();
        try {
            PackageInfo info = manager.getPackageInfo(ctx.getPackageName(), 0);
            return String.valueOf(info.versionCode);
        } catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return "";
    }


    public static String getLocalLanguage(Context context) {
        String language = "en";
        try {
            language = context.getResources().getConfiguration().locale.toString();
        } catch (Throwable e) {

        }
        return language;
    }


    /**
     * 判断是否平板设备
     *
     * @param context
     * @return true:平板,false:手机
     */
    public boolean isTabletDevice(Context context) {
        return (context.getResources().getConfiguration().screenLayout & Configuration.SCREENLAYOUT_SIZE_MASK) >=
                Configuration.SCREENLAYOUT_SIZE_LARGE;
    }

    public static int getScreenType(Context context) {
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), context.getClass().getName());
            ActivityInfo info = context.getPackageManager().getActivityInfo(componentName, PackageManager.GET_ACTIVITIES);
            if (info.screenOrientation == ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE) {
                int angle = ((WindowManager) context.getSystemService(Context.WINDOW_SERVICE)).getDefaultDisplay().getRotation();
                if (angle == Surface.ROTATION_90) {
                    return Constants.SCREEN_TYPE_LAND;
                } else if (angle == Surface.ROTATION_270) {
                    return Constants.SCREEN_TYPE_REVERSE_LAND;
                }
            } else if (info.screenOrientation == ActivityInfo.SCREEN_ORIENTATION_LANDSCAPE) {
                return Constants.SCREEN_TYPE_LAND;
            } else if (info.screenOrientation == ActivityInfo.SCREEN_ORIENTATION_PORTRAIT) {
                return Constants.SCREEN_TYPE_PORT;
            }
        } catch (Exception e) {
        }

        return -1;
    }

    public static boolean isSensorLand(Context context) {
        try {
            ComponentName componentName = new ComponentName(context.getPackageName(), context.getClass().getName());
            ActivityInfo info = context.getPackageManager().getActivityInfo(componentName, PackageManager.GET_ACTIVITIES);
            if (info.screenOrientation == ActivityInfo.SCREEN_ORIENTATION_SENSOR_LANDSCAPE) {
                return true;
            }
        } catch (Exception e) {
        }

        return false;
    }

    /**
     * 获得设备型号
     *
     * @return
     */
    public static String getBuildModel() {
        return Build.MODEL;
    }

    /**
     * 获得系统版本号
     *
     * @return int类型 6.0.1=23
     */
    public static String getSystemVersion() {
        return Build.VERSION.SDK_INT + "";
    }

    public static String getCpuInfo() {
        JSONObject json = new JSONObject();
        try {
            json.put("cpu_num", CpuUtils.getNumCpuCores());
            json.put("cpu_abi", CpuUtils.getCpuAbi());
            json.put("hardware", CpuUtils.getCpuHardware());
            json.put("max_freq", CpuUtils.getCpuMaxFreq());
            json.put("min_freq", CpuUtils.getCpuMinFreq());
        } catch (JSONException e) {

        }
        return json.toString();
    }

    /**
     * 获得网络类型
     *
     * @param ctx
     * @return
     */
    public static String getNetWorkType(Context ctx) {
        try {
            ConnectivityManager connectMgr = (ConnectivityManager) ctx
                    .getSystemService(Context.CONNECTIVITY_SERVICE);

            NetworkInfo info = connectMgr.getActiveNetworkInfo();
            if (info == null) {
                return "none";
            }
            if (info.getType() == ConnectivityManager.TYPE_WIFI) {
                return "wifi";
            }
            if (info.getType() == ConnectivityManager.TYPE_MOBILE) {
                return "mobile";
            }
        } catch (Throwable e) {
            //LogHelper.v("BaseDeviceInfoHelper getNetWorkType failed");
        }

        return "unkown";
    }

    /**
     * 可用内存信息-单位GB
     *
     * @param context
     * @return
     */
    public static String getAvailMemory(Context context) {// 获取android当前可用内存大小
        ActivityManager am = (ActivityManager) context.getSystemService(Context.ACTIVITY_SERVICE);
        ActivityManager.MemoryInfo mi = new ActivityManager.MemoryInfo();
        am.getMemoryInfo(mi);
        //mi.availMem; 当前系统的可用内存
        return String.valueOf(mi.availMem / 1024 / 1024 / 1024).trim() + "GB";// 将获取的内存大小规格化
//        return Formatter.formatFileSize(context, mi.availMem).trim();// 将获取的内存大小规格化
    }

    /**
     * 内存信息-单位GB
     *
     * @param context
     * @return
     */
    public static String getTotalMemory(Context context) {
        String str1 = "/proc/meminfo";// 系统内存信息文件
        String str2;
        String[] arrayOfString;
        long initial_memory = 0;
        try {
            FileReader localFileReader = new FileReader(str1);
            BufferedReader localBufferedReader = new BufferedReader(
                    localFileReader, 8192);
            str2 = localBufferedReader.readLine();// 读取meminfo第一行，系统总内存大小
            if (TextUtils.isEmpty(str2)) {
                return "";
            }
            if (!str2.contains("\\s+")){
                return "";
            }
            arrayOfString = str2.split("\\s+");
//            for (String num : arrayOfString) {
//                Log.i(str2, num + "\t");
//            }
            initial_memory = Integer.valueOf(arrayOfString[1]).intValue() / 1024 / 1024;// 获得系统总内存，单位是KB，/1024/1024 转换为GB
            localBufferedReader.close();

        } catch (IOException e) {

        }
        return String.valueOf(initial_memory) + "GB";// Byte转换为KB或者MB，内存大小规格化
    }
}
