package com.css.sdk.cservice.base.http;

import android.text.TextUtils;

import com.css.sdk.cservice.base.utils.LogUtils;
import com.luck.picture.lib.config.PictureMimeType;
import com.luck.picture.lib.entity.LocalMedia;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by Holaverse on 2017/5/23.
 */

public class HttpClientHelper {
    // 上传的超时时间(s)
    private static int UPLOAD_TIMEOUT=1000 * 60 * 2;

    public static HttpResponse httpGet(final String url, final String userAgent) throws Exception {
        return httpSend("get", url, null, userAgent, null);
    }

    public static HttpResponse httpPost(final String url, final String requestBody, final String userAgent) throws Exception {
        return httpSend("post", url, requestBody, userAgent, null);
    }


    public static HttpResponse httpPost(final String url, final String requestBody, final String userAgent, final String enctyType) throws Exception {
        return httpSend("post", url, requestBody, userAgent, enctyType);
    }

    public static HttpResponse httpPost(final String url, final String requestBody, final Map<String, String> heardMap, final String userAgent, final String enctyType) throws Exception {
        return httpSend("post", url, requestBody, heardMap, userAgent, enctyType);
    }

    public static HttpResponse httpUpload(final String url, Map<String, String> params, List<String> files) throws Exception {
        HttpResponse body = null;
        HttpClient client = HttpClient.builder().setUrl(url);
        client.setConnectTimeout(UPLOAD_TIMEOUT);
        client.setReadTimeout(UPLOAD_TIMEOUT);
        client.setUseCaches(false);
        body = client.requestUpload(params, files);
        return body;
    }
    public static void httpDownLoad(final String httpUrl, final String filePath, DownLoadListener downLoadListener) throws Exception {
        downloadFile(httpUrl, filePath, downLoadListener);
    }


    private static HttpResponse httpSend(String type, final String url, final String requestBody, final String userAgent, final String enctyType) throws Exception {
        HttpResponse body = null;
//        try {
        HttpClient client = HttpClient.builder().setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty(requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty(userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        body = client.request();
//        } catch (Throwable e) {
//
//        }
        return body;
    }

    /**
     * 使用带有header的http请求
     *
     * @param type
     * @param url
     * @param requestBody
     * @param headerMap
     * @param userAgent
     * @param enctyType
     * @return
     * @throws Exception
     */
    private static HttpResponse httpSend(String type, final String url, final String requestBody, final Map<String, String> headerMap, final String userAgent, final String enctyType) throws Exception {
        HttpResponse body = null;
//        try {
        HttpClient client = HttpClient.builder().setUrl(url);
        if (type.equals("post")) {
            client.setRequestMethod(HttpClient.METHOD_POST);
        }
        if (!TextUtils.isEmpty(requestBody)) {
            client.setRequestBody(requestBody);
        }
        if (!TextUtils.isEmpty(userAgent)) {
            client.setUserAgent(userAgent);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (!TextUtils.isEmpty(enctyType)) {
            client.setEnctyType(enctyType);
        }
        if (headerMap != null && headerMap.size() != 0) {
            Iterator<Map.Entry<String, String>> iterator = headerMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, String> entry = iterator.next();
                String key = entry.getKey();
                String value = entry.getValue();
                client.setRequestHeader(key, value);
            }
        }
        body = client.request();
//        } catch (Throwable e) {
//
//        }
        return body;
    }

    private static void downloadFile(String httpUrl, String filePath, DownLoadListener downLoadListener) {
        try {
            // 新建一个URL对象
            URL url = new URL(httpUrl);
            // 打开一个HttpURLConnection连接
            HttpURLConnection urlConn = (HttpURLConnection) url.openConnection();
            // 设置连接主机超时时间
            urlConn.setConnectTimeout(5 * 1000);
            // 设置从主机读取数据超时
            urlConn.setReadTimeout(5 * 1000);
            // 设置是否使用缓存  默认是true
            urlConn.setUseCaches(true);
            // 设置为Post请求
            urlConn.setRequestMethod("POST");
            // urlConn设置请求头信息
            // 设置请求中的媒体类型信息。
            urlConn.setRequestProperty("Content-Type", "application/json");
            // 设置客户端与服务连接类型
            urlConn.addRequestProperty("Connection", "Keep-Alive");
            // 开始连接
            urlConn.connect();
            // 判断请求是否成功
            if (urlConn.getResponseCode() == 200) {
                File descFile = new File(filePath);
                FileOutputStream fos = new FileOutputStream(descFile);
                ;
                byte[] buffer = new byte[1024];
                int len;
                InputStream inputStream = urlConn.getInputStream();
                while ((len = inputStream.read(buffer)) != -1) {
                    // 写到本地
                    fos.write(buffer, 0, len);
                }
            } else {
                downLoadListener.onFail("fail in download video, error : " + urlConn.getResponseCode());
                LogUtils.i("fail in download video, error : " + urlConn.getResponseCode());
                return;
            }
            if (downLoadListener != null) {
                LocalMedia localMedia = new LocalMedia();
                localMedia.setPath(filePath);
                localMedia.setMimeType(PictureMimeType.MIME_TYPE_VIDEO);
                downLoadListener.onSuccess(localMedia);
            }
            // 关闭连接
            urlConn.disconnect();
        } catch (Exception e) {
            if (downLoadListener != null) {
                downLoadListener.onFail("has error in download video " + e.getMessage());
            }
            LogUtils.i("has error in download video " + e.getMessage());
        }
    }

    public interface DownLoadListener {
        public void onSuccess(LocalMedia media);

        public void onFail(String msg);
    }
}
