package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.GridView;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.CssTextGridViewAdapter;
import com.css.sdk.cservice.adapter.RecommendQaAapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.FaqTagEnum;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.utils.DataFilter;
import com.css.sdk.cservice.utils.LocalInfo;

import org.w3c.dom.Text;

import java.util.ArrayList;
import java.util.List;

public class ReommendListActivity extends BaseActivity implements RecommendQaAapter.RecommendQAItemClickListener {

    private ListView listView;
    private boolean mLoading;
    private RecommendQaAapter mListViewAapter;
    private List<FaqItem> faqList;
    private LinearLayout loadingRoot;
    private RelativeLayout titleBack;
    private LinearLayout titleSearchRoot;
    private EditText titleSearch;
    private TextView confirmTv;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.css_activity_reommend_list);
        initView();
        requestData("");
    }

    private void initView() {
        listView = findViewById(R.id.css_recommend_list);
        setEmptyView(listView);
        loadingRoot = findViewById(R.id.css_loading_layout);
        titleBack = findViewById(R.id.css_title_back);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        titleSearchRoot = findViewById(R.id.rl_title_search);
        titleSearchRoot.setVisibility(View.VISIBLE);
        titleSearch = findViewById(R.id.css_title_search);
        confirmTv = findViewById(R.id.css_title_search_confirm);
        confirmTv.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String targetStr = titleSearch.getText().toString().trim();
                if (TextUtils.isEmpty(targetStr)) {
                    return;
                }
                requestData(targetStr);

            }
        });
        titleSearch.addTextChangedListener(new TextWatcher() {
            @Override
            public void beforeTextChanged(CharSequence s, int start, int count, int after) {

            }

            @Override
            public void onTextChanged(CharSequence s, int start, int before, int count) {

            }

            @Override
            public void afterTextChanged(Editable s) {
//                // 如果什么内容都没有,重置当前tag下的recommendList
                if (TextUtils.isEmpty(titleSearch.getText().toString().trim())) {
                    requestData("");
                }
            }
        });
        mListViewAapter = new RecommendQaAapter(this, this);
        listView.setAdapter(mListViewAapter);
    }

    private void setEmptyView(ListView listView) {
        TextView tv = new TextView(this);
        tv.setText(getResources().getString(R.string.css_text_nodata));
        tv.setGravity(Gravity.CENTER);
        LinearLayout.LayoutParams params = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.FILL_PARENT, LinearLayout.LayoutParams.FILL_PARENT);
        addContentView(tv, params);
        listView.setEmptyView(tv);
    }

    /**
     * 对本地数据进行查询
     */
    private void localSearch() {
        showLoading();
        String searchStr = titleSearch.getText().toString().trim().toLowerCase();
        ArrayList<FaqItem> resultList = new ArrayList<>();
        if (faqList != null && !faqList.isEmpty()) {
            for (FaqItem item : faqList) {
                if (LocalInfo.getLanguage(this) == LocalInfo.LocalLanguage.ZHSIMPLE) {
                    if (item.questionZhSimple.contains(searchStr)) {
                        resultList.add(item);
                    }
                } else if (LocalInfo.getLanguage(this) == LocalInfo.LocalLanguage.ZHTrandition) {
                    if (item.questionZh.contains(searchStr)) {
                        resultList.add(item);
                    }
                } else {
                    if (item.questionEn.toLowerCase().contains(searchStr)) {
                        resultList.add(item);
                    }
                }
            }
        }
        hideLoading();
        if (resultList.isEmpty()) {
            Toast.makeText(this, getResources().getString(R.string.css_text_search_noresult), Toast.LENGTH_SHORT).show();
            return;
        }
        mListViewAapter.bindData(resultList);
    }

    private void requestData(String content) {
        showLoading();
        BusinessRequest.getFaqMatchList(content, new RequestCallback<List<FaqItem>>() {
            @Override
            public void onSuccess(final List<FaqItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        faqList = result;
//                        if (result.isEmpty()) {
////                            setEmptyView(listView);
//
//                            return;
//                        }
                        mListViewAapter.bindData(result);
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }


    private void showLoading() {
        mLoading = true;
        loadingRoot.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        if (!mLoading) return;
        mLoading = false;
        loadingRoot.setVisibility(View.GONE);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }


    @Override
    public void onItemClick(int position, FaqItem faqItem) {
        Intent i = new Intent(this, RecommendDetailActvity.class);
        i.putExtra(Constants.KEY_RECOMMEND_ID, faqItem.id);
        startActivity(i);
    }
}
