package com.css.sdk.cservice;

import android.content.Context;
import android.content.Intent;

import com.css.sdk.cservice.activity.CssVideoPlayActivity;
import com.css.sdk.cservice.activity.FeedBackActivity;
import com.css.sdk.cservice.userdata.AASHelper;
import com.css.sdk.cservice.userdata.AlyTokenHelper;
import com.css.sdk.cservice.userdata.GlobalData;
import com.luck.picture.lib.app.IApp;
import com.luck.picture.lib.app.PictureAppMaster;
import com.luck.picture.lib.crash.PictureSelectorCrashUtils;

public class CServiceSdk {
    private static boolean sHasInited;


    public static void initSdk(final Context context, final InitCallback callback) {

        if (sHasInited) {
            return;
        }

        if (null == context) {
            notifyInitFail(callback, "context is null, can't init CServiceSdk.");
            return;
        }

        GlobalData.cacheContext(context);
        // 初始化pictureselect
        PictureAppMaster.getInstance().setApp(new IApp() {
            @Override
            public Context getAppContext() {
                return context;
            }
        });
//        PictureSelectorCrashUtils.init(new PictureSelectorCrashUtils.CrashAppListener() {
//            @Override
//            public void onFinishApp(Thread thread, Throwable throwable) {
//                notifyInitFail(callback, "failed to init pictureselect" + throwable.getMessage());
//            }
//        });

        try {
            if (!AlyTokenHelper.isExistAlyLib()) {
                notifyInitFail(callback, "missed alynasis SDK, can't init CServiceSdk.");
                return;
            }
            if (!AASHelper.isExistAASLib()) {
                notifyInitFail(callback, "missed account SDK, can't init CServiceSdk.");
                return;
            }

            AlyTokenHelper.freshPramaters();
            AASHelper.freshGgid();

            sHasInited = true;
            if (callback != null) {
                callback.onInitSuccess();
            }
        } catch (Exception e) {
            notifyInitFail(callback, "failed to init CServiceSdk, exception: " + e.getMessage());
        }
    }

    /**
     * 反馈问题入口
     */
    public static void feedback(Context context) {
        if (!sHasInited) {
            return;
        }

        AlyTokenHelper.freshPramaters();
        AASHelper.freshGgid();

        if (!GlobalData.isNecessaryParamtersAvailable()) {
            return;
        }

        if (null == GlobalData.getContext()) {
            GlobalData.cacheContext(context);
        }

        if (null == context) {
            context = GlobalData.getContext();
        }

        if (null == context) {
            return;
        }
        GlobalData.setConfig(context);
        Intent intent = new Intent(context, FeedBackActivity.class);
        intent.addFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.startActivity(intent);
    }

    private static void notifyInitFail(InitCallback callback, String msg) {
        if (null != callback) {
            callback.onInitFailed(msg);
        }
    }


}
