package com.css.sdk.cservice.business;

import android.content.Context;
import android.text.TextUtils;

import com.css.sdk.BuildConfig;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.DeviceInfoHelper;
import com.css.sdk.cservice.base.utils.LogUtils;
import com.css.sdk.cservice.data.FaqDetail;
import com.css.sdk.cservice.data.FaqItem;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.data.OrderDetail;
import com.css.sdk.cservice.data.Picture;
import com.css.sdk.cservice.request.HttpCallback;
import com.css.sdk.cservice.request.HttpRequest;
import com.css.sdk.cservice.request.URLConstant;
import com.css.sdk.cservice.userdata.GlobalData;
import com.css.sdk.cservice.utils.LocalInfo;

import org.json.JSONArray;
import org.json.JSONObject;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.css.sdk.cservice.base.Constants.JSON_PICNAME;
import static com.css.sdk.cservice.base.Constants.JSON_VIDEONAME;

public class BusinessRequest {

    public static void getHistoryList(final RequestCallback<ArrayList<HistoryItem>> callback) {
        String url = URLConstant.getFqaHistory() + "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken();

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    JSONObject data = jsonObject.getJSONObject("data");
                    JSONArray items = data.getJSONArray("questions");
                    JSONObject row = null;
                    ArrayList<HistoryItem> list = new ArrayList<>();
                    for (int i = 0; i < items.length(); i++) {
                        row = items.getJSONObject(i);
                        HistoryItem item = new HistoryItem();
                        item.parseJsonString(row);
                        list.add(item);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getHistoryList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getDetail(long questionId, final RequestCallback<OrderDetail> callback) {
        String url = URLConstant.getOderDetail() + "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken()
                + "&questionId=" + questionId;
        LogUtils.i("getDetail url : " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("getDetail onResponseSuccess : " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    JSONObject data = jsonObject.getJSONObject("data");
                    OrderDetail detail = new OrderDetail();
                    detail.parseJsonString(data);

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getDetail has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getDetail onResponedFail : code " + code + " msg " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void feedBackN(Context context, String questionId, List<Picture> pics, List<Picture> videos, List<Picture> cancelPics, String type, String contact, String content, final RequestCallback<String> callback) {
        String pdtid = GlobalData.getProductId();
        String url = URLConstant.feedbackNew();
        url += "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken() + "&pdtid=" + pdtid
                + "&accept_media=Y" + "&platform=" + Constants.PLATFORM_ANDROID + "&type=" + type+"&language="+ LocalInfo.getLanguageStr(context)
                + "&product_version=" + DeviceInfoHelper.getAppVersion(context) + "&sdk_version=" + BuildConfig.VERSION_NAME + "&device_model="
                + DeviceInfoHelper.getBuildModel().replace(" ", "-")
                + "&system_version=" + DeviceInfoHelper.getSystemVersion();
        try {
            String str = URLEncoder.encode(URLEncoder.encode(content, "UTF-8"), "UTF-8");
            url += "&content=" + str;
        } catch (Exception e) {

        }
        if (!TextUtils.isEmpty(contact)) {
            url += "&contact=" + contact;
        }

        if (!TextUtils.isEmpty(questionId)) {
            url += "&questionId=" + questionId;
        }

        if (!pics.isEmpty()) {
            url += "&pics=" + list2String(pics);
        }
        if (!videos.isEmpty()) {
            url += "&videos=" + list2String(videos);
        }

        if (!cancelPics.isEmpty()) {
            url += "&cancelPics=" + list2String(cancelPics);
        }
        url = addDeviceInfoInUrl(context, url);
        LogUtils.i("feedBackN request url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("feedBackN onResponseSuccess result is " + result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    if (code == 200) {
                        callback.onSuccess("success");
                    } else if (code == 403) {
                        callback.onFail("feedback error ", CSSErrors.CSS_REPORT_LIMIT_EXCEPTION);
                    }
                } catch (Throwable e) {
                    LogUtils.w("feedBackN has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("feedBackN onResponedFail code: " + code + " msg :" + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private static void addMediaInfo(HashMap<String, String> maps, String tag, String content) {
        maps.put(tag, content);
    }

    private static String addDeviceInfoInUrl(Context context, String url) {
        url += "&memory=" + DeviceInfoHelper.getTotalMemory(context);
        url += "&memory_used=" + DeviceInfoHelper.getAvailMemory(context);
        url += "&net_type=" + DeviceInfoHelper.getNetWorkType(context);
        try {
            url += "&cpu_model=" + URLEncoder.encode(URLEncoder.encode(DeviceInfoHelper.getCpuInfo(), "UTF-8"), "UTF-8");
            ;
        } catch (Exception e) {
        }
        return url;
    }

    private static String list2String(List<Picture> list) {
        StringBuilder sb = new StringBuilder();
        for (Picture picture : list) {
            sb.append(picture.getPicName()).append(",");
        }
        String result = sb.toString();

        return result.substring(0, result.length() - 1);
    }

    public static void delete(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.deleteWorkOrder() + "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken() + "&questionId=" + questionId;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("delete has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void fqaFinish(String questionId, final RequestCallback<String> callback) {
        String url = URLConstant.feedbackFinish() + "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken() + "&questionId=" + questionId;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("fqaFinish has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void evaluateWorkOrder(String questionId, boolean satisfy, final RequestCallback<String> callback) {
        String s = satisfy ? "y" : "n";
        String url = URLConstant.evaluate() + "?gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken() + "&questionId=" + questionId + "&satisfied=" + s;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail("fail", code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("evaluateWorkOrder has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void uploadPics(final List<String> files, final RequestCallback<Map<String, List<Picture>>> callback) {
        String requestURL = URLConstant.uploadPic();
        Map<String, String> params = new HashMap<>();
        params.put("gameGuestId", GlobalData.getAasGgid());
        params.put("token", GlobalData.getAlyToken());
        HttpRequest.requestUploadByPost(requestURL, params, files, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    JSONObject data = jsonObject.getJSONObject("data");
                    List<Picture> picList = new ArrayList<>();
                    List<Picture> videoList = new ArrayList<>();
                    if (data.has(JSON_PICNAME)) {
                        JSONArray picItems = data.getJSONArray(JSON_PICNAME);
                        picList = new ArrayList<>();
                        for (int i = 0; i < picItems.length(); i++) {
                            Picture pic = new Picture();
                            pic.setPicName(picItems.get(i).toString());
                            pic.setUrl(files.get(i));
                            picList.add(pic);
                        }
                    }

                    if (data.has(JSON_VIDEONAME)) {
                        JSONArray videoItems = data.getJSONArray(JSON_VIDEONAME);
                        videoList = new ArrayList<>();
                        for (int i = 0; i < videoItems.length(); i++) {
                            Picture pic = new Picture();
                            pic.setPicName(videoItems.get(i).toString());
                            pic.setUrl(files.get(i));
                            videoList.add(pic);
                        }
                    }
                    Map<String, List<Picture>> resultMap = new HashMap<>();
                    if (!videoList.isEmpty()) {
                        resultMap.put(JSON_VIDEONAME, videoList);
                    }
                    if (!picList.isEmpty()) {
                        resultMap.put(JSON_PICNAME, picList);
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(resultMap);
                    } else {
                        callback.onFail("fail", code);
                    }
                    LogUtils.i(" uploadPics onResponseSuccess: result" + result);
                } catch (Throwable e) {
                    LogUtils.i(" uploadPics onResponseSuccess: error " + e.getMessage());
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqList(String type, final RequestCallback<List<FaqItem>> callback) {
        String url = URLConstant.getFaqList() + "?type=" + type + "&gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken()
                + "&platform=" + Constants.PLATFORM_ANDROID + "&pdtid=" + GlobalData.getProductId();
        LogUtils.i("faqlist url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("questions");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }
                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqList has error :" + e.getMessage(), e);
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("faqlist onResponedFail is " + code + " error " + e.getMessage());
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqMatchList(String content, final RequestCallback<List<FaqItem>> callback) {
        String url = "";
        try {
            content = URLEncoder.encode(content, "utf-8");
            url = URLConstant.getFaqMatch() + "?content=" + content + "&gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken()
                    + "&platform=" + Constants.PLATFORM_ANDROID + "&pdtid=" + GlobalData.getProductId();
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        LogUtils.i("getFaqMatchList url is " + url);
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    LogUtils.i("getFaqMatchList onResponseSuccess result is " + result);
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");
                    ArrayList<FaqItem> list = new ArrayList<>();
                    if (jsonObject.has("data")) {
                        JSONObject data = jsonObject.getJSONObject("data");
                        JSONArray items = data.getJSONArray("faqs");
                        JSONObject row = null;
                        for (int i = 0; i < items.length(); i++) {
                            row = items.getJSONObject(i);
                            FaqItem item = new FaqItem();
                            item.parseJsonString(row);
                            list.add(item);
                        }
                    }

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(list);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.i("getFaqMatchList onResponseSuccess has error  is " + e.getMessage());
                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                LogUtils.i("getFaqMatchList onResponedFail  " + e.getMessage() + " code " + code);
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void getFaqDetail(Context context,String faqId, final RequestCallback<FaqDetail> callback) {
        String url = URLConstant.getFaqDetail() + "?faqId=" + faqId + "&gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken();
        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                LogUtils.i("faqdetail result is "+result);
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    JSONObject data = jsonObject.getJSONObject("data");
                    FaqDetail detail = new FaqDetail();
                    detail.parseJsonString(context,data);

                    if (code == 200 && isSuccess) {
                        callback.onSuccess(detail);
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("getFaqDetail has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    public static void evaluateFqa(String faqId, boolean isHelp, final RequestCallback<String> callback) {
        String help = isHelp ? "y" : "n";
        String url = URLConstant.evaluateFaq() + "?faqId=" + faqId + "&gameGuestId=" + GlobalData.getAasGgid() + "&token=" + GlobalData.getAlyToken()
                + "&help=" + help;

        HttpRequest.requestHttpByPost(url, null, new HttpCallback<String>() {
            @Override
            public void onResponseSuccess(String result) {
                try {
                    JSONObject jsonObject = new JSONObject(result);
                    int code = jsonObject.getInt("code");
                    boolean isSuccess = jsonObject.getBoolean("success");
                    String msg = jsonObject.getString("message");

                    if (code == 200 && isSuccess) {
                        callback.onSuccess("success");
                    } else {
                        callback.onFail(msg, code);
                    }
                } catch (Throwable e) {
                    LogUtils.w("evaluateFqa has error :" + e.getMessage(), e);

                    callback.onFail(e.getMessage(), CSSErrors.CSS_ERROR_RESPONSE_JSON_EXCEPTION);
                }
            }

            @Override
            public void onResponedFail(Throwable e, int code) {
                callback.onFail(e.getMessage(), code);
            }
        });
    }

    private void getDevicesInfo(Context context) {
        String totalMemory = DeviceInfoHelper.getTotalMemory(context);// Byte转换为KB或者MB，内存大小规格化
        String availableMe = DeviceInfoHelper.getAvailMemory(context);
        String netWork = DeviceInfoHelper.getNetWorkType(context);
        String cpuType = DeviceInfoHelper.getCpuInfo();
    }
}
