package com.css.sdk.cservice.adapter;

import android.app.Activity;
import android.content.Intent;
import android.graphics.BitmapFactory;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.Button;
import android.widget.ImageView;

import com.css.sdk.R;
import com.css.sdk.cservice.activity.SelectPictureActivity;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.imageloader.ImageLoader;
import com.css.sdk.cservice.listener.ItemDeleteCallback;

import java.util.ArrayList;

public class AlbumPicAdapter extends BaseAdapter {
    private Activity mActivity;
    private ArrayList<String> selectedPictures = new ArrayList<>();
    private LayoutInflater layoutInflater;

    public AlbumPicAdapter(Activity activity) {
        this.mActivity = activity;
        layoutInflater = LayoutInflater.from(activity);
    }

    public void addData(ArrayList<String> selectedPictures) {
        this.selectedPictures.addAll(selectedPictures);
    }

    public ArrayList<String> getSelectPictures(){
        return this.selectedPictures;
    }

    public void clear() {
        this.selectedPictures.clear();
    }

    @Override
    public int getCount() {
        return selectedPictures.size() + 1;
    }

    @Override
    public Object getItem(int position) {
        return null;
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    @Override
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder = new ViewHolder();
        convertView = layoutInflater.inflate(R.layout.css_grid_addpic_item, null);

        holder.image = (ImageView) convertView.findViewById(R.id.child_iv);
        holder.delete = (Button) convertView.findViewById(R.id.css_delete);

        if (position == selectedPictures.size()) {
            holder.delete.setVisibility(View.GONE);
            holder.image.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    selectClick();
                }
            });
            holder.image.setImageBitmap(BitmapFactory.decodeResource(mActivity.getResources(), R.drawable.css_add_pic));
            if (position == 3) {
                holder.image.setVisibility(View.GONE);
            }
        } else {
            holder.delete.setVisibility(View.VISIBLE);
            ImageLoader.getInstance().load(selectedPictures.get(position), holder.image);
            holder.delete.setOnClickListener(new View.OnClickListener() {
                @Override
                public void onClick(View v) {
                    if (deleteCallback != null) {
                        deleteCallback.onDeleted(selectedPictures.get(position));
                    }
                    selectedPictures.remove(position);
                    notifyDataSetChanged();
                }
            });

        }
        return convertView;
    }

    private static final int REQUEST_PICK = 0;

    private void selectClick() {
        Intent intent = new Intent();
        intent.setClass(mActivity, SelectPictureActivity.class);

        intent.putExtra(Constants.KEY_SELECTED_PIC_NUM, selectedPictures.size());

        if (selectedPictures.size() < 3) {
            mActivity.startActivityForResult(intent, REQUEST_PICK);
        }
    }

    public class ViewHolder {
        public ImageView image;
        public Button delete;
    }

    public void setDeleteCallback(ItemDeleteCallback deleteCallback) {
        this.deleteCallback = deleteCallback;
    }

    private ItemDeleteCallback deleteCallback;

}
