package com.css.sdk.cservice.activity;

import android.content.Intent;
import android.os.Bundle;
import android.view.KeyEvent;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;

import com.css.sdk.R;
import com.css.sdk.cservice.adapter.HistoryAdapter;
import com.css.sdk.cservice.base.CSSErrors;
import com.css.sdk.cservice.base.Constants;
import com.css.sdk.cservice.base.utils.ToastUtil;
import com.css.sdk.cservice.business.BusinessRequest;
import com.css.sdk.cservice.business.RequestCallback;
import com.css.sdk.cservice.data.HistoryItem;
import com.css.sdk.cservice.listener.ItemDeleteCallback;
import com.css.sdk.cservice.refresh.RefreshLayout;
import com.css.sdk.cservice.refresh.Swipe;
import com.css.sdk.cservice.view.SlideListView;

import java.util.ArrayList;

public class HistoryActivity extends BaseActivity implements Swipe.OnRefreshListener {

    private RelativeLayout titleBack;
    private TextView tv_title;
    private SlideListView listView;
    private TextView feedback;
    private HistoryAdapter adapter;
    private LinearLayout loadingRl;
    private RefreshLayout refreshLayout;
    private RelativeLayout bottomRl;

    private boolean mLoading;
    private ArrayList<HistoryItem> historyList;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.css_activity_history);
        initView();
        requestData(true);
    }

    private void initView() {
        titleBack = findViewById(R.id.css_title_back);
        titleBack.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                finish();
            }
        });
        bottomRl = findViewById(R.id.css_bottom_rl);
        bottomRl.setVisibility(View.GONE);
        tv_title = findViewById(R.id.css_title_tv);
        tv_title.setText(R.string.css_string_feedback_history);
        refreshLayout = findViewById(R.id.css_refresh_layout);
        refreshLayout.setVisibility(View.GONE);
        listView = findViewById(R.id.css_history_listview);
        feedback = findViewById(R.id.css_feedback_tv);
        feedback.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {

                finish();
                startActivity(new Intent(HistoryActivity.this,FeedBackActivity.class));
            }
        });
        loadingRl = findViewById(R.id.css_loading_layout);
    }

    private void requestData(final boolean showLoading) {
        if (showLoading) {
            showLoading();
        }
        BusinessRequest.getHistoryList(new RequestCallback<ArrayList<HistoryItem>>() {
            @Override
            public void onSuccess(final ArrayList<HistoryItem> result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        if (showLoading) {
                            hideLoading();
                        } else {
                            refreshLayout.finishRefresh();
                        }
                        if (result == null || result.isEmpty()) {
                            ToastUtil.showToastTip(getApplicationContext(), R.string.css_string_history_empty, false);
                        }
                        historyList = result;
                        if (adapter == null) {
                            bottomRl.setVisibility(View.VISIBLE);
                            refreshLayout.setOnRefreshListener(HistoryActivity.this);
                            refreshLayout.setVisibility(View.VISIBLE);
                            adapter = new HistoryAdapter(HistoryActivity.this, historyList);
                            adapter.setDeleteCallback(new ItemDeleteCallback() {
                                @Override
                                public void onDeleted(String id) {
                                    requestDelete(id);
                                }
                            });
                            listView.setAdapter(adapter);
                            listView.setItemClickListener(new SlideListView.OnItemClickListener() {
                                @Override
                                public void clicked(int position) {
                                    HistoryItem item = historyList.get(position);
                                    if (item != null) {
                                        Intent intent = new Intent(HistoryActivity.this, DetailActivity.class);
                                        intent.putExtra(Constants.KEY_DETAIL_ID, item.id);
                                        intent.putExtra(Constants.KEY_IS_UNREAD, item.status.equals(Constants.QA_STATUS_PROCESSED));
                                        startActivityForResult(intent, Constants.HISTORY_RESULT_CODE);
                                    }
                                }
                            });
                        } else {
                            adapter.bindData(historyList);
                            adapter.notifyDataSetChanged();
                        }

                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    private void requestDelete(final String questionId) {
        if (mLoading) return;
        showLoading();
        BusinessRequest.delete(questionId, new RequestCallback<String>() {
            @Override
            public void onSuccess(String result) {
                runOnUiThread(new Runnable() {
                    @Override
                    public void run() {
                        hideLoading();
                        if (adapter != null) {
                            for (HistoryItem item : historyList) {
                                if (String.valueOf(item.id).equals(questionId)) {
                                    historyList.remove(item);
                                    break;
                                }
                            }
                            adapter.bindData(historyList);
                            adapter.notifyDataSetChanged();
                        }
                    }
                });
            }

            @Override
            public void onFail(String msg, int code) {
                hideLoading();
                showError(code);
            }
        });
    }

    @Override
    public void refresh() {
        requestData(false);
    }

    private void showLoading() {
        mLoading = true;
        loadingRl.setVisibility(View.VISIBLE);
    }

    private void hideLoading() {
        if (!mLoading) return;
        mLoading = false;
        loadingRl.setVisibility(View.GONE);
    }

    @Override
    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (mLoading && keyCode == KeyEvent.KEYCODE_BACK) {
            return true;//不执行父类点击事件
        }
        return super.onKeyDown(keyCode, event);//继续执行父类其他点击事件
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (resultCode == Constants.HISTORY_RESULT_CODE) {
            if (data != null) {
                Bundle bundle = data.getExtras();
                if (bundle != null) {
                    long orderId = bundle.getLong(Constants.KEY_ORDER_ID);
                    int type = bundle.getInt(Constants.KEY_ORDER_CHANGE_TYPE);
                    if (historyList != null && !historyList.isEmpty()) {
                        for (HistoryItem item : historyList) {
                            if (item.id == orderId) {
                                if (type == Constants.ORDER_CHANGE_TO_READED) {
                                    item.status = Constants.QA_STATUS_PROCESSED_READ;
                                } else if (type == Constants.ORDER_CHANGE_TO_CLOSED) {
                                    item.status = Constants.QA_STATUS_CLOSED;
                                }
                                adapter.bindData(historyList);
                                adapter.notifyDataSetChanged();
                                break;
                            }
                        }
                    }
                }

            }
        }
    }
}
