/*
 * Decompiled with CFR 0.152.
 */
package com.csfrequency.firebase.devicestore;

import android.bluetooth.BluetoothAdapter;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.v4.app.NotificationManagerCompat;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.firebase.FirebaseApp;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.FirebaseUser;
import com.google.firebase.firestore.DocumentReference;
import com.google.firebase.firestore.DocumentSnapshot;
import com.google.firebase.firestore.FirebaseFirestore;
import com.google.firebase.firestore.FirebaseFirestoreException;
import com.google.firebase.firestore.Transaction;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.InstanceIdResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FirebaseDeviceStore {
    private static final String DEFAULT_COLLECTION_PATH = "user-devices";
    private static final String TAG = "FirebaseDeviceStore";
    private final FirebaseAuth auth;
    private final String collectionPath;
    private final Context context;
    private final FirebaseFirestore firestore;
    private final FirebaseInstanceId instanceId;
    private FirebaseAuth.AuthStateListener authStateListener;
    private String currentToken = null;
    private FirebaseUser currentUser = null;
    private boolean subscribed = false;

    public FirebaseDeviceStore(Context context, FirebaseApp app) {
        this(context, app, DEFAULT_COLLECTION_PATH);
    }

    public FirebaseDeviceStore(Context context, FirebaseApp app, String collectionPath) {
        this.auth = FirebaseAuth.getInstance((FirebaseApp)app);
        this.collectionPath = collectionPath;
        this.context = context;
        this.firestore = FirebaseFirestore.getInstance((FirebaseApp)app);
        this.instanceId = FirebaseInstanceId.getInstance((FirebaseApp)app);
        LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)new TokenReceiver(), new IntentFilter("onNewToken"));
    }

    public void signOut() {
        if (this.currentUser != null && this.currentToken != null) {
            this.deleteToken(this.currentUser.getUid(), this.currentToken);
        }
        this.currentUser = null;
    }

    public void subscribe() {
        if (this.subscribed) {
            return;
        }
        if (!NotificationManagerCompat.from((Context)this.context).areNotificationsEnabled()) {
            throw new RuntimeException("Notifications are not enabled");
        }
        this.subscribed = true;
        this.currentUser = this.auth.getCurrentUser();
        this.instanceId.getInstanceId().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<InstanceIdResult>(){

            public void onComplete(@NonNull Task<InstanceIdResult> task) {
                if (task.isSuccessful()) {
                    FirebaseDeviceStore.this.currentToken = ((InstanceIdResult)task.getResult()).getToken();
                    if (FirebaseDeviceStore.this.currentToken != null && FirebaseDeviceStore.this.currentUser != null) {
                        FirebaseDeviceStore.this.addToken(FirebaseDeviceStore.this.currentUser.getUid(), FirebaseDeviceStore.this.currentToken);
                    }
                } else {
                    Log.w((String)FirebaseDeviceStore.TAG, (String)"Failed to load FCM token", (Throwable)task.getException());
                }
            }
        });
        this.authStateListener = new FirebaseAuth.AuthStateListener(){

            public void onAuthStateChanged(@NonNull FirebaseAuth firebaseAuth) {
                FirebaseUser authUser = firebaseAuth.getCurrentUser();
                if (authUser != null && FirebaseDeviceStore.this.currentUser == null && FirebaseDeviceStore.this.currentToken != null) {
                    FirebaseDeviceStore.this.currentUser = authUser;
                    FirebaseDeviceStore.this.addToken(FirebaseDeviceStore.this.currentUser.getUid(), FirebaseDeviceStore.this.currentToken);
                } else if (authUser == null && FirebaseDeviceStore.this.currentUser != null) {
                    Log.w((String)FirebaseDeviceStore.TAG, (String)"You need to call the `logout` method on the DeviceStore before logging out the user");
                    FirebaseDeviceStore.this.currentUser = authUser;
                }
            }
        };
        this.auth.addAuthStateListener(this.authStateListener);
    }

    public void unsubscribe() {
        if (this.authStateListener != null) {
            this.auth.removeAuthStateListener(this.authStateListener);
            this.authStateListener = null;
        }
        this.currentToken = null;
        this.currentUser = null;
        this.subscribed = false;
    }

    private void addToken(final String userId, final String token) {
        final DocumentReference docRef = this.userRef(userId);
        this.firestore.runTransaction((Transaction.Function)new Transaction.Function<Void>(){

            public Void apply(Transaction transaction) throws FirebaseFirestoreException {
                DocumentSnapshot doc = transaction.get(docRef);
                if (doc.exists()) {
                    List devices = FirebaseDeviceStore.this.getDevices(doc);
                    if (!FirebaseDeviceStore.this.containsDevice(devices, token)) {
                        devices.add(FirebaseDeviceStore.this.createDevice(token));
                    }
                    transaction.update(docRef, "devices", (Object)devices, new Object[0]);
                } else {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("devices", FirebaseDeviceStore.this.createDevice(token));
                    data.put("userId", userId);
                    transaction.set(docRef, data);
                }
                return null;
            }
        });
    }

    private void deleteToken(final String userId, final String token) {
        final DocumentReference docRef = this.userRef(userId);
        this.firestore.runTransaction((Transaction.Function)new Transaction.Function<Void>(){

            public Void apply(Transaction transaction) throws FirebaseFirestoreException {
                DocumentSnapshot doc = transaction.get(docRef);
                if (doc.exists()) {
                    List devices = FirebaseDeviceStore.this.getDevices(doc);
                    devices = FirebaseDeviceStore.this.removeDevice(devices, token);
                    transaction.update(docRef, "devices", (Object)devices, new Object[0]);
                } else {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("devices", new ArrayList());
                    data.put("userId", userId);
                    transaction.set(docRef, data);
                }
                return null;
            }
        });
    }

    private void updateToken(final String userId, final String oldToken, final String newToken) {
        final DocumentReference docRef = this.userRef(userId);
        this.firestore.runTransaction((Transaction.Function)new Transaction.Function<Void>(){

            public Void apply(Transaction transaction) throws FirebaseFirestoreException {
                DocumentSnapshot doc = transaction.get(docRef);
                if (doc.exists()) {
                    List devices = FirebaseDeviceStore.this.getDevices(doc);
                    if (oldToken != null) {
                        devices = FirebaseDeviceStore.this.removeDevice(devices, oldToken);
                    }
                    if (newToken != null && !FirebaseDeviceStore.this.containsDevice(devices, newToken)) {
                        devices.add(FirebaseDeviceStore.this.createDevice(newToken));
                    }
                    transaction.update(docRef, "devices", (Object)devices, new Object[0]);
                } else if (newToken != null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("devices", FirebaseDeviceStore.this.createDevice(newToken));
                    data.put("userId", userId);
                    transaction.set(docRef, data);
                } else {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("devices", new ArrayList());
                    data.put("userId", userId);
                    transaction.set(docRef, data);
                }
                return null;
            }
        });
    }

    private boolean containsDevice(List<Map<String, String>> devices, String token) {
        for (Map<String, String> device : devices) {
            if (!token.equals(device.get("fcmToken"))) continue;
            return true;
        }
        return false;
    }

    private Map<String, String> createDevice(String token) {
        HashMap<String, String> device = new HashMap<String, String>();
        device.put("deviceId", this.getDeviceId());
        device.put("fcmToken", token);
        device.put("name", this.getDeviceName());
        device.put("os", this.getOS());
        device.put("type", "Android");
        return device;
    }

    private String getDeviceId() {
        return Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id");
    }

    private List<Map<String, String>> getDevices(DocumentSnapshot snapshot) {
        List devices = (List)snapshot.get("devices");
        if (devices == null) {
            return new ArrayList<Map<String, String>>();
        }
        return devices;
    }

    private String getDeviceName() {
        String permission = "android.permission.BLUETOOTH";
        int res = this.context.checkCallingOrSelfPermission(permission);
        if (res == 0) {
            try {
                BluetoothAdapter myDevice = BluetoothAdapter.getDefaultAdapter();
                if (myDevice != null) {
                    return myDevice.getName();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return "Unknown";
    }

    private String getOS() {
        return "Android " + Build.VERSION.RELEASE;
    }

    private List<Map<String, String>> removeDevice(List<Map<String, String>> devices, String token) {
        ArrayList<Map<String, String>> filteredDevices = new ArrayList<Map<String, String>>();
        for (Map<String, String> device : devices) {
            if (token.equals(device.get("fcmToken"))) continue;
            filteredDevices.add(device);
        }
        return filteredDevices;
    }

    private DocumentReference userRef(String userId) {
        return this.firestore.collection(this.collectionPath).document(userId);
    }

    private class TokenReceiver
    extends BroadcastReceiver {
        private TokenReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (!FirebaseDeviceStore.this.subscribed) {
                return;
            }
            String token = intent.getStringExtra("token");
            if ((token == null && FirebaseDeviceStore.this.currentToken != null || !token.equals(FirebaseDeviceStore.this.currentToken)) && FirebaseDeviceStore.this.currentUser != null) {
                FirebaseDeviceStore.this.updateToken(FirebaseDeviceStore.this.currentUser.getUid(), FirebaseDeviceStore.this.currentToken, token);
            }
            FirebaseDeviceStore.this.currentToken = token;
        }
    }
}

