/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.htime.jdk12;

import com.cronutils.htime.DateTimeFormatParser;
import com.cronutils.htime.DatetimeFormatterConstants;
import com.cronutils.htime.HDateTimeFormat;
import com.cronutils.htime.jdk12.JDK12DatetimeFormatterConstants;
import java.text.SimpleDateFormat;
import java.util.Locale;
import org.apache.commons.lang3.Validate;

public class JDK12HDateTimeFormat
implements HDateTimeFormat<SimpleDateFormat> {
    private Locale locale;
    private DatetimeFormatterConstants constants;

    public JDK12HDateTimeFormat(Locale locale) {
        Validate.notNull((Object)locale, (String)"Locale should not be null", (Object[])new Object[0]);
        this.locale = locale;
        this.constants = new JDK12DatetimeFormatterConstants();
    }

    @Override
    public SimpleDateFormat forPattern(String expression) {
        Validate.notBlank((CharSequence)expression, (String)"Expression must not be blank or null", (Object[])new Object[0]);
        DateTimeFormatParser parser = new DateTimeFormatParser(this.constants, this.locale);
        expression = expression.replaceAll("\\s+", " ");
        expression = expression.replace(" AM", "AM").replace(" am", "am").replace(" PM", "PM").replace(" pm", "pm");
        String[] parts = expression.split(" ");
        StringBuilder builder = new StringBuilder();
        for (String part : parts) {
            builder.append(String.format("%s ", parser.parsePattern(part)));
        }
        return new SimpleDateFormat(builder.toString().trim());
    }
}

