/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser;

import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.parser.CronParser$$Lambda$1;
import com.cronutils.parser.CronParserField;
import com.cronutils.utils.Preconditions;
import com.cronutils.utils.StringUtils;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class CronParser {
    private final Map<Integer, List<CronParserField>> expressions = new HashMap<Integer, List<CronParserField>>();
    private CronDefinition cronDefinition;

    public CronParser(CronDefinition cronDefinition) {
        this.cronDefinition = Preconditions.checkNotNull(cronDefinition, "CronDefinition must not be null");
        this.buildPossibleExpressions(cronDefinition);
    }

    private void buildPossibleExpressions(CronDefinition cronDefinition) {
        List sortedExpression = cronDefinition.getFieldDefinitions().stream().map(CronParser$$Lambda$1.lambdaFactory$()).sorted(CronParserField.createFieldTypeComparator()).collect(Collectors.toList());
        ImmutableList.Builder expressionBuilder = ImmutableList.builder();
        for (CronParserField field : sortedExpression) {
            if (field.isOptional()) {
                ImmutableList possibleExpression = expressionBuilder.build();
                this.expressions.put(possibleExpression.size(), (List<CronParserField>)possibleExpression);
            }
            expressionBuilder.add((Object)field);
        }
        ImmutableList longestPossibleExpression = expressionBuilder.build();
        this.expressions.put(longestPossibleExpression.size(), (List<CronParserField>)longestPossibleExpression);
    }

    public Cron parse(String expression) {
        Preconditions.checkNotNull(expression, "Expression must not be null");
        String replaced = expression.replaceAll("\\s+", " ").trim();
        if (StringUtils.isEmpty(replaced)) {
            throw new IllegalArgumentException("Empty expression!");
        }
        String[] expressionParts = replaced.toUpperCase().split(" ");
        int expressionLength = expressionParts.length;
        List<CronParserField> fields = this.expressions.get(expressionLength);
        if (fields == null) {
            throw new IllegalArgumentException(String.format("Cron expression contains %s parts but we expect one of %s", expressionLength, this.expressions.keySet()));
        }
        try {
            int size = fields.size();
            ArrayList<CronField> results = new ArrayList<CronField>(size + 1);
            for (int j = 0; j < size; ++j) {
                results.add(fields.get(j).parse(expressionParts[j]));
            }
            return new Cron(this.cronDefinition, results).validate();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Failed to parse '%s'. %s", expression, e.getMessage()), e);
        }
    }

    static /* synthetic */ CronParserField lambda$buildPossibleExpressions$0(FieldDefinition fieldDefinition) {
        return new CronParserField(fieldDefinition.getFieldName(), fieldDefinition.getConstraints(), fieldDefinition.isOptional());
    }
}

