/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.CronField;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EveryFieldValueGenerator
extends FieldValueGenerator {
    private static final Logger log = LoggerFactory.getLogger(EveryFieldValueGenerator.class);

    public EveryFieldValueGenerator(CronField cronField) {
        super(cronField);
        log.trace(String.format("processing \"%s\" at %s", cronField.getExpression().asString(), DateTime.now()));
    }

    @Override
    public int generateNextValue(int reference) throws NoSuchValueException {
        int remainder;
        if (reference >= this.cronField.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        Every every = (Every)this.cronField.getExpression();
        int referenceWithoutOffset = reference - this.offset();
        int period = every.getPeriod().getValue();
        int next = reference + (period - (remainder = referenceWithoutOffset % period));
        if (next < this.cronField.getConstraints().getStartRange()) {
            return this.cronField.getConstraints().getStartRange();
        }
        if (next > this.cronField.getConstraints().getEndRange()) {
            throw new NoSuchValueException();
        }
        return next;
    }

    @Override
    public int generatePreviousValue(int reference) throws NoSuchValueException {
        Every every = (Every)this.cronField.getExpression();
        int period = every.getPeriod().getValue();
        int remainder = reference % period;
        if (remainder == 0) {
            return reference - period;
        }
        return reference - remainder;
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            log.debug("Failed to generate candidates", (Throwable)e);
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        Every every = (Every)this.cronField.getExpression();
        int start = this.cronField.getConstraints().getStartRange();
        return (value - start) % every.getPeriod().getValue() == 0;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof Every;
    }

    @VisibleForTesting
    int offset() {
        return this.cronField.getConstraints().getStartRange();
    }
}

