/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.constraint;

import com.cronutils.model.field.value.SpecialChar;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.Validate;

public class FieldConstraints {
    private Map<String, Integer> stringMapping;
    private Map<Integer, Integer> intMapping;
    private Set<SpecialChar> specialChars;
    private int startRange;
    private int endRange;

    public FieldConstraints(Map<String, Integer> stringMapping, Map<Integer, Integer> intMapping, Set<SpecialChar> specialChars, int startRange, int endRange) {
        this.stringMapping = Collections.unmodifiableMap((Map)Validate.notNull(stringMapping, (String)"String mapping must not be null", (Object[])new Object[0]));
        this.intMapping = Collections.unmodifiableMap((Map)Validate.notNull(intMapping, (String)"Integer mapping must not be null", (Object[])new Object[0]));
        this.specialChars = Collections.unmodifiableSet((Set)Validate.notNull(specialChars, (String)"Special (non-standard) chars set must not be null", (Object[])new Object[0]));
        this.startRange = startRange;
        this.endRange = endRange;
    }

    public int getStartRange() {
        return this.startRange;
    }

    public int getEndRange() {
        return this.endRange;
    }

    public Set<SpecialChar> getSpecialChars() {
        return this.specialChars;
    }

    public boolean isInRange(int value) {
        return value >= this.getStartRange() && value <= this.getEndRange();
    }

    public Map<String, Integer> getStringMapping() {
        return this.stringMapping;
    }

    public Map<Integer, Integer> getIntMapping() {
        return this.intMapping;
    }
}

