/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.time.ExecutionTimeBuilder;
import com.cronutils.model.time.NearestValue;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionTime {
    private static final Logger log = LoggerFactory.getLogger(ExecutionTime.class);
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    @VisibleForTesting
    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = (CronDefinition)Validate.notNull((Object)cronDefinition);
        this.yearsValueGenerator = (FieldValueGenerator)Validate.notNull((Object)yearsValueGenerator);
        this.daysOfWeekCronField = (CronField)Validate.notNull((Object)daysOfWeekCronField);
        this.daysOfMonthCronField = (CronField)Validate.notNull((Object)daysOfMonthCronField);
        this.months = (TimeNode)Validate.notNull((Object)months);
        this.hours = (TimeNode)Validate.notNull((Object)hours);
        this.minutes = (TimeNode)Validate.notNull((Object)minutes);
        this.seconds = (TimeNode)Validate.notNull((Object)seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        block9: for (CronFieldName name : CronFieldName.values()) {
            if (fields.get((Object)name) == null) continue;
            switch (name) {
                case SECOND: {
                    executionTimeBuilder.forSecondsMatching(fields.get((Object)name));
                    continue block9;
                }
                case MINUTE: {
                    executionTimeBuilder.forMinutesMatching(fields.get((Object)name));
                    continue block9;
                }
                case HOUR: {
                    executionTimeBuilder.forHoursMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_WEEK: {
                    executionTimeBuilder.forDaysOfWeekMatching(fields.get((Object)name));
                    continue block9;
                }
                case DAY_OF_MONTH: {
                    executionTimeBuilder.forDaysOfMonthMatching(fields.get((Object)name));
                    continue block9;
                }
                case MONTH: {
                    executionTimeBuilder.forMonthsMatching(fields.get((Object)name));
                    continue block9;
                }
                case YEAR: {
                    executionTimeBuilder.forYearsMatching(fields.get((Object)name));
                }
            }
        }
        return executionTimeBuilder.build();
    }

    public DateTime nextExecution(DateTime date) {
        Validate.notNull((Object)date);
        try {
            DateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals((Object)date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1));
            }
            return nextMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    DateTime nextClosestMatch(DateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = null;
        int lowestMonth = this.months.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            int newYear = this.yearsValueGenerator.generateNextValue(date.getYear());
            days = this.generateDays(this.cronDefinition, new DateTime(newYear, lowestMonth, 1, 0, 0));
            return this.initDateTime(this.yearsValueGenerator.generateNextValue(date.getYear()), lowestMonth, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthOfYear())) {
            NearestValue nearestValue = this.months.getNextValue(date.getMonthOfYear(), 0);
            int nextMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), 1, 1, 0, 0, 0, date.getZone()).plusYears(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMonthOfYear()) {
                date = date.plusYears(1);
            }
            days = this.generateDays(this.cronDefinition, new DateTime(date.getYear(), nextMonths, 1, 0, 0));
            return this.initDateTime(date.getYear(), nextMonths, days.getValues().get(0), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        days = this.generateDays(this.cronDefinition, date);
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getNextValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), 1, 0, 0, 0, date.getZone()).plusMonths(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getDayOfMonth()) {
                date = date.plusMonths(1);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), nearestValue.getValue(), lowestHour, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHourOfDay())) {
            NearestValue nearestValue = this.hours.getNextValue(date.getHourOfDay(), 0);
            int nextHours = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), 0, 0, 0, date.getZone()).plusDays(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getHourOfDay()) {
                date = date.plusDays(1);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), nextHours, lowestMinute, lowestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinuteOfHour())) {
            NearestValue nearestValue = this.minutes.getNextValue(date.getMinuteOfHour(), 0);
            int nextMinutes = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), 0, 0, date.getZone()).plusHours(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getMinuteOfHour()) {
                date = date.plusHours(1);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), nextMinutes, lowestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecondOfMinute())) {
            NearestValue nearestValue = this.seconds.getNextValue(date.getSecondOfMinute(), 0);
            int nextSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), 0, date.getZone()).plusMinutes(nearestValue.getShifts());
                return this.nextClosestMatch(newDate);
            }
            if (nearestValue.getValue() < date.getSecondOfMinute()) {
                date = date.plusMinutes(1);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), nextSeconds, date.getZone());
        }
        return date;
    }

    DateTime previousClosestMatch(DateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = this.generateDays(this.cronDefinition, date);
        int highestMonth = this.months.getValues().get(this.months.getValues().size() - 1);
        int highestDay = days.getValues().get(days.getValues().size() - 1);
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (year.isEmpty()) {
            int highestDayOfMonth;
            int previousYear = this.yearsValueGenerator.generatePreviousValue(date.getYear());
            if (highestDay > 28 && highestDay > (highestDayOfMonth = new DateTime(previousYear, highestMonth, 1, 0, 0).dayOfMonth().getMaximumValue())) {
                NearestValue nearestValue = days.getPreviousValue(highestDay, 1);
                if (nearestValue.getShifts() > 0) {
                    DateTime newDate = new DateTime(previousYear, highestMonth, 1, 23, 59, 59).minusMonths(nearestValue.getShifts()).dayOfMonth().withMaximumValue();
                    return this.previousClosestMatch(newDate);
                }
                highestDay = nearestValue.getValue();
            }
            return this.initDateTime(previousYear, highestMonth, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.months.getValues().contains(date.getMonthOfYear())) {
            NearestValue nearestValue = this.months.getPreviousValue(date.getMonthOfYear(), 0);
            int previousMonths = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), 12, 31, 23, 59, 59).minusYears(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), previousMonths, highestDay, highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            NearestValue nearestValue = days.getPreviousValue(date.getDayOfMonth(), 0);
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), 1, 23, 59, 59).minusMonths(nearestValue.getShifts()).dayOfMonth().withMaximumValue();
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), nearestValue.getValue(), highestHour, highestMinute, highestSecond, date.getZone());
        }
        if (!this.hours.getValues().contains(date.getHourOfDay())) {
            NearestValue nearestValue = this.hours.getPreviousValue(date.getHourOfDay(), 0);
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), 23, 59, 59).minusDays(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), nearestValue.getValue(), highestMinute, highestSecond, date.getZone());
        }
        if (!this.minutes.getValues().contains(date.getMinuteOfHour())) {
            NearestValue nearestValue = this.minutes.getPreviousValue(date.getMinuteOfHour(), 0);
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), 59, 59).minusHours(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), nearestValue.getValue(), highestSecond, date.getZone());
        }
        if (!this.seconds.getValues().contains(date.getSecondOfMinute())) {
            NearestValue nearestValue = this.seconds.getPreviousValue(date.getSecondOfMinute(), 0);
            int previousSeconds = nearestValue.getValue();
            if (nearestValue.getShifts() > 0) {
                DateTime newDate = new DateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), 59).minusMinutes(nearestValue.getShifts());
                return this.previousClosestMatch(newDate);
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), previousSeconds, date.getZone());
        }
        return date;
    }

    TimeNode generateDays(CronDefinition cronDefinition, DateTime date) {
        boolean questionMarkSupported = cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK).getConstraints().isSpecialCharAllowed(SpecialChar.QUESTION_MARK);
        if (questionMarkSupported) {
            return new TimeNode(this.generateDayCandidatesQuestionMarkSupported(date.getYear(), date.getMonthOfYear(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        }
        return new TimeNode(this.generateDayCandidatesQuestionMarkNotSupported(date.getYear(), date.getMonthOfYear(), ((DayOfWeekFieldDefinition)cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
    }

    public Duration timeToNextExecution(DateTime date) {
        return new Interval((ReadableInstant)date, (ReadableInstant)this.nextExecution(date)).toDuration();
    }

    public DateTime lastExecution(DateTime date) {
        Validate.notNull((Object)date);
        try {
            DateTime previousMatch = this.previousClosestMatch(date);
            if (previousMatch.equals((Object)date)) {
                previousMatch = this.previousClosestMatch(date.minusSeconds(1));
            }
            return previousMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Duration timeFromLastExecution(DateTime date) {
        return new Interval((ReadableInstant)this.lastExecution(date), (ReadableInstant)date).toDuration();
    }

    public boolean isMatch(DateTime date) {
        return this.nextExecution(this.lastExecution(date)).equals((Object)date);
    }

    private List<Integer> generateDayCandidatesQuestionMarkNotSupported(int year, int month, WeekDay mondayDoWValue) {
        DateTime date = new DateTime(year, month, 1, 1, 1);
        HashSet candidates = Sets.newHashSet();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        } else if (this.daysOfMonthCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        } else if (this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        }
        ArrayList candidatesList = Lists.newArrayList((Iterable)candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private List<Integer> generateDayCandidatesQuestionMarkSupported(int year, int month, WeekDay mondayDoWValue) {
        DateTime date = new DateTime(year, month, 1, 1, 1);
        HashSet candidates = Sets.newHashSet();
        if (this.daysOfMonthCronField.getExpression() instanceof Always && this.daysOfWeekCronField.getExpression() instanceof Always) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        } else if (this.daysOfMonthCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(-1, date.dayOfMonth().getMaximumValue()));
        } else if (this.daysOfWeekCronField.getExpression() instanceof QuestionMark) {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        } else {
            candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
            candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        }
        ArrayList candidatesList = Lists.newArrayList((Iterable)candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private DateTime initDateTime(int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute, DateTimeZone timeZone) {
        DateTime date = new DateTime(0, 1, 1, 0, 0, 0, timeZone).plusYears(years).plusMonths(monthsOfYear - 1).plusDays(dayOfMonth - 1).plusHours(hoursOfDay).plusMinutes(minutesOfHour).plusSeconds(secondsOfMinute);
        return this.ensureSameDate(date, years, monthsOfYear, dayOfMonth, hoursOfDay, minutesOfHour, secondsOfMinute, timeZone);
    }

    private DateTime ensureSameDate(DateTime date, int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute, DateTimeZone timeZone) {
        if (date.getSecondOfMinute() != secondsOfMinute) {
            date = date.plusSeconds(secondsOfMinute - date.getSecondOfMinute());
        }
        if (date.getMinuteOfHour() != minutesOfHour) {
            date = date.plusMinutes(minutesOfHour - date.getMinuteOfHour());
        }
        if (date.getHourOfDay() != hoursOfDay) {
            date = date.plusHours(hoursOfDay - date.getHourOfDay());
        }
        if (date.getDayOfMonth() != dayOfMonth) {
            date = date.plusDays(dayOfMonth - date.getDayOfMonth());
        }
        if (date.getMonthOfYear() != monthsOfYear) {
            date = date.plusMonths(monthsOfYear - date.getMonthOfYear());
        }
        if (date.getYear() != years) {
            date = date.plusYears(years - date.getYear());
        }
        return date;
    }
}

