/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser.field;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.QuestionMark;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FieldParser {
    private final char[] specialCharsMinusStar = new char[]{'/', '-', ','};
    private Pattern lPattern = Pattern.compile("[0-9]L", 2);
    private Pattern wPattern = Pattern.compile("[0-9]W", 2);
    private FieldConstraints constraints;

    public FieldParser(FieldConstraints constraints) {
        this.constraints = (FieldConstraints)Validate.notNull((Object)constraints, (String)"FieldConstraints cannot be null", (Object[])new Object[0]);
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny((CharSequence)expression, (char[])this.specialCharsMinusStar)) {
            if ("*".equals(expression)) {
                return new Always(this.constraints);
            }
            if ("?".equals(expression)) {
                return new QuestionMark(this.constraints);
            }
            return this.parseOn(expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            And and = new And();
            for (String exp : array) {
                and.and(this.parse(exp));
            }
            return and;
        }
        array = expression.split("-");
        if (array.length > 1) {
            return this.parseBetween(array);
        }
        String[] values = expression.split("/");
        if (values.length == 2) {
            String value = values[1];
            this.constraints.validateAllCharsValid(value);
            return new Every(this.constraints, new IntegerFieldValue(Integer.parseInt(value)));
        }
        if (values.length == 1) {
            throw new IllegalArgumentException("Missing steps for expression: " + expression);
        }
        throw new IllegalArgumentException("Invalid expression: " + expression);
    }

    private Between parseBetween(String[] array) {
        if (array[1].contains("/")) {
            String[] every = array[1].split("/");
            return new Between(this.constraints, this.map(this.constraints, array[0]), this.map(this.constraints, every[0]), this.mapToIntegerFieldValue(every[1]));
        }
        String from = array[0];
        String to = array[1];
        return new Between(this.constraints, this.map(this.constraints, from), this.map(this.constraints, to));
    }

    private On parseOn(String exp) {
        this.constraints.validateAllCharsValid(exp);
        if (exp.contains("#")) {
            return this.parseOnWithHash(exp);
        }
        if (exp.contains("LW")) {
            return this.parseOnWithLW(exp);
        }
        if (this.lPattern.matcher(exp).find() || exp.equalsIgnoreCase("L")) {
            return this.parseOnWithL(exp);
        }
        if (this.wPattern.matcher(exp).find()) {
            return this.parseOnWithW(exp);
        }
        return new On(this.constraints, this.mapToIntegerFieldValue(exp), new SpecialCharFieldValue(SpecialChar.NONE), new IntegerFieldValue(-1));
    }

    private On parseOnWithHash(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.HASH);
        String[] array = exp.split("#");
        IntegerFieldValue nth = this.mapToIntegerFieldValue(array[1]);
        if (array[0].isEmpty()) {
            throw new IllegalArgumentException("Time should be specified!");
        }
        return new On(this.constraints, this.mapToIntegerFieldValue(array[0]), specialChar, nth);
    }

    private On parseOnWithQuestionMark(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.QUESTION_MARK);
        if ("".equals(exp = exp.replace("?", ""))) {
            return new On(this.constraints, new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: '?', found: %s", exp));
    }

    private On parseOnWithLW(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.LW);
        if ("".equals(exp = exp.replace("LW", ""))) {
            return new On(this.constraints, new IntegerFieldValue(-1), specialChar, new IntegerFieldValue(-1));
        }
        throw new IllegalArgumentException(String.format("Expected: LW, found: %s", exp));
    }

    private On parseOnWithL(String exp) {
        SpecialCharFieldValue specialChar = new SpecialCharFieldValue(SpecialChar.L);
        exp = exp.replace("L", "");
        IntegerFieldValue time = new IntegerFieldValue(-1);
        if (!"".equals(exp)) {
            time = this.mapToIntegerFieldValue(exp);
        }
        return new On(this.constraints, time, specialChar, new IntegerFieldValue(-1));
    }

    private On parseOnWithW(String exp) {
        return new On(this.constraints, this.mapToIntegerFieldValue(exp.replace("W", "")), new SpecialCharFieldValue(SpecialChar.W), new IntegerFieldValue(-1));
    }

    private IntegerFieldValue mapToIntegerFieldValue(String string) {
        this.constraints.validateAllCharsValid(string);
        try {
            return new IntegerFieldValue(this.constraints.stringToInt(string));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Invalid value. Expected some integer, found %s", string));
        }
    }

    private FieldValue map(FieldConstraints constraints, String string) {
        constraints.validateAllCharsValid(string);
        for (SpecialChar sc : SpecialChar.values()) {
            if (!sc.toString().equals(string)) continue;
            return new SpecialCharFieldValue(sc);
        }
        return new IntegerFieldValue(constraints.stringToInt(string));
    }
}

