/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.descriptor;

import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.Validate;

abstract class DescriptionStrategy {
    protected Function<Integer, String> nominalValueFunction;
    protected ResourceBundle bundle;

    public DescriptionStrategy(ResourceBundle bundle) {
        this.bundle = bundle;
        this.nominalValueFunction = new Function<Integer, String>(){

            public String apply(Integer integer) {
                return "" + integer;
            }
        };
    }

    public abstract String describe();

    protected String describe(FieldExpression fieldExpression) {
        return this.describe(fieldExpression, false);
    }

    protected String describe(FieldExpression fieldExpression, boolean and) {
        Validate.notNull((Object)fieldExpression, (String)"CronFieldExpression should not be null!", (Object[])new Object[0]);
        if (fieldExpression instanceof Always) {
            return this.describe((Always)fieldExpression, and);
        }
        if (fieldExpression instanceof And) {
            return this.describe((And)fieldExpression);
        }
        if (fieldExpression instanceof Between) {
            return this.describe((Between)fieldExpression, and);
        }
        if (fieldExpression instanceof Every) {
            return this.describe((Every)fieldExpression, and);
        }
        if (fieldExpression instanceof On) {
            return this.describe((On)fieldExpression, and);
        }
        return "";
    }

    protected String nominalValue(FieldValue fieldValue) {
        Validate.notNull((Object)fieldValue, (String)"FieldValue must not be null", (Object[])new Object[0]);
        if (fieldValue instanceof IntegerFieldValue) {
            return (String)this.nominalValueFunction.apply((Object)((IntegerFieldValue)fieldValue).getValue());
        }
        return fieldValue.toString();
    }

    protected String describe(Always always, boolean and) {
        if (always.getEvery().getTime().getValue() <= 1) {
            return "";
        }
        return this.describe(always.getEvery(), and);
    }

    protected String describe(And and) {
        ArrayList expressions = Lists.newArrayList();
        ArrayList onExpressions = Lists.newArrayList();
        for (FieldExpression fieldExpression : and.getExpressions()) {
            if (fieldExpression instanceof On) {
                onExpressions.add(fieldExpression);
                continue;
            }
            expressions.add(fieldExpression);
        }
        StringBuilder builder = new StringBuilder();
        if (!onExpressions.isEmpty()) {
            builder.append(this.bundle.getString("at"));
            this.createAndDescription(builder, onExpressions).append(" %p");
        }
        if (!expressions.isEmpty()) {
            this.createAndDescription(builder, expressions);
        }
        return builder.toString();
    }

    private StringBuilder createAndDescription(StringBuilder builder, List<FieldExpression> expressions) {
        if (expressions.size() - 2 >= 0) {
            for (int j = 0; j < expressions.size() - 2; ++j) {
                builder.append(String.format(" %s, ", this.describe(expressions.get(j), true)));
            }
            builder.append(String.format(" %s ", this.describe(expressions.get(expressions.size() - 2), true)));
        }
        builder.append(String.format(" %s ", this.bundle.getString("and")));
        builder.append(this.describe(expressions.get(expressions.size() - 1), true));
        return builder;
    }

    protected String describe(Between between, boolean and) {
        return this.describe(between.getEvery(), and) + MessageFormat.format(this.bundle.getString("between_x_and_y"), this.nominalValue(between.getFrom()), this.nominalValue(between.getTo())) + " ";
    }

    protected String describe(Every every, boolean and) {
        String description = every.getTime().getValue() > 1 ? String.format("%s %s ", this.bundle.getString("every"), this.nominalValue(every.getTime())) + " %p " : this.bundle.getString("every") + " %s ";
        return description;
    }

    protected String describe(On on, boolean and) {
        if (and) {
            return this.nominalValue(on.getTime());
        }
        return String.format("%s %s ", this.bundle.getString("at"), this.nominalValue(on.getTime())) + "%s";
    }
}

