/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time;

import com.cronutils.mapper.WeekDay;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.time.ExecutionTimeBuilder;
import com.cronutils.model.time.TimeNode;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGeneratorFactory;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class ExecutionTime {
    private CronDefinition cronDefinition;
    private FieldValueGenerator yearsValueGenerator;
    private CronField daysOfWeekCronField;
    private CronField daysOfMonthCronField;
    private TimeNode months;
    private TimeNode hours;
    private TimeNode minutes;
    private TimeNode seconds;

    @VisibleForTesting
    ExecutionTime(CronDefinition cronDefinition, FieldValueGenerator yearsValueGenerator, CronField daysOfWeekCronField, CronField daysOfMonthCronField, TimeNode months, TimeNode hours, TimeNode minutes, TimeNode seconds) {
        this.cronDefinition = (CronDefinition)Validate.notNull((Object)cronDefinition);
        this.yearsValueGenerator = (FieldValueGenerator)Validate.notNull((Object)yearsValueGenerator);
        this.daysOfWeekCronField = (CronField)Validate.notNull((Object)daysOfWeekCronField);
        this.daysOfMonthCronField = (CronField)Validate.notNull((Object)daysOfMonthCronField);
        this.months = (TimeNode)Validate.notNull((Object)months);
        this.hours = (TimeNode)Validate.notNull((Object)hours);
        this.minutes = (TimeNode)Validate.notNull((Object)minutes);
        this.seconds = (TimeNode)Validate.notNull((Object)seconds);
    }

    public static ExecutionTime forCron(Cron cron) {
        Map<CronFieldName, CronField> fields = cron.retrieveFieldsAsMap();
        ExecutionTimeBuilder executionTimeBuilder = new ExecutionTimeBuilder(cron.getCronDefinition());
        if (fields.containsKey((Object)CronFieldName.SECOND)) {
            executionTimeBuilder.forSecondsMatching(fields.get((Object)CronFieldName.SECOND));
        }
        executionTimeBuilder.forMinutesMatching(fields.get((Object)CronFieldName.MINUTE)).forHoursMatching(fields.get((Object)CronFieldName.HOUR)).forDaysOfMonthMatching(fields.get((Object)CronFieldName.DAY_OF_MONTH)).forDaysOfWeekMatching(fields.get((Object)CronFieldName.DAY_OF_WEEK)).forMonthsMatching(fields.get((Object)CronFieldName.MONTH));
        if (fields.containsKey((Object)CronFieldName.YEAR)) {
            executionTimeBuilder.forYearsMatching(fields.get((Object)CronFieldName.YEAR));
        }
        return executionTimeBuilder.build();
    }

    public DateTime nextExecution(DateTime date) {
        Validate.notNull((Object)date);
        try {
            DateTime nextMatch = this.nextClosestMatch(date);
            if (nextMatch.equals((Object)date)) {
                nextMatch = this.nextClosestMatch(date.plusSeconds(1));
            }
            return nextMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    DateTime nextClosestMatch(DateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = new TimeNode(this.generateDayCandidates(date.getYear(), date.getMonthOfYear(), ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        int lowestMonth = this.months.getValues().get(0);
        int lowestDay = days.getValues().get(0);
        int lowestHour = this.hours.getValues().get(0);
        int lowestMinute = this.minutes.getValues().get(0);
        int lowestSecond = this.seconds.getValues().get(0);
        if (year.isEmpty()) {
            return this.initDateTime(this.yearsValueGenerator.generateNextValue(date.getYear()), lowestMonth, lowestDay, lowestHour, lowestMinute, lowestSecond);
        }
        if (!this.months.getValues().contains(date.getMonthOfYear())) {
            return this.initDateTime(date.getYear(), this.months.getNextValue(date.getMonthOfYear(), 0).getValue(), lowestDay, lowestHour, lowestMinute, lowestSecond);
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), days.getNextValue(date.getDayOfMonth(), 0).getValue(), lowestHour, lowestMinute, lowestSecond);
        }
        if (!this.hours.getValues().contains(date.getHourOfDay())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), this.hours.getNextValue(date.getHourOfDay(), 0).getValue(), lowestMinute, lowestSecond);
        }
        if (!this.minutes.getValues().contains(date.getMinuteOfHour())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), this.minutes.getNextValue(date.getMinuteOfHour(), 0).getValue(), lowestSecond);
        }
        if (!this.seconds.getValues().contains(date.getSecondOfMinute())) {
            int nextSeconds = this.seconds.getNextValue(date.getSecondOfMinute(), 0).getValue();
            if (nextSeconds <= date.getSecondOfMinute()) {
                return this.nextClosestMatch(date.plusSeconds(1));
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), nextSeconds);
        }
        return date;
    }

    DateTime previousClosestMatch(DateTime date) throws NoSuchValueException {
        List<Integer> year = this.yearsValueGenerator.generateCandidates(date.getYear(), date.getYear());
        TimeNode days = new TimeNode(this.generateDayCandidates(date.getYear(), date.getMonthOfYear(), ((DayOfWeekFieldDefinition)this.cronDefinition.getFieldDefinition(CronFieldName.DAY_OF_WEEK)).getMondayDoWValue()));
        int highestMonth = this.months.getValues().get(this.months.getValues().size() - 1);
        int highestDay = days.getValues().get(days.getValues().size() - 1);
        int highestHour = this.hours.getValues().get(this.hours.getValues().size() - 1);
        int highestMinute = this.minutes.getValues().get(this.minutes.getValues().size() - 1);
        int highestSecond = this.seconds.getValues().get(this.seconds.getValues().size() - 1);
        if (year.isEmpty()) {
            return this.initDateTime(this.yearsValueGenerator.generatePreviousValue(date.getYear()), highestMonth, highestDay, highestHour, highestMinute, highestSecond);
        }
        if (!this.months.getValues().contains(date.getMonthOfYear())) {
            return this.initDateTime(date.getYear(), this.months.getPreviousValue(date.getMonthOfYear(), 0).getValue(), highestDay, highestHour, highestMinute, highestSecond);
        }
        if (!days.getValues().contains(date.getDayOfMonth())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), days.getPreviousValue(date.getDayOfMonth(), 0).getValue(), highestHour, highestMinute, highestSecond);
        }
        if (!this.hours.getValues().contains(date.getHourOfDay())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), this.hours.getPreviousValue(date.getHourOfDay(), 0).getValue(), highestMinute, highestSecond);
        }
        if (!this.minutes.getValues().contains(date.getMinuteOfHour())) {
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), this.minutes.getPreviousValue(date.getMinuteOfHour(), 0).getValue(), highestSecond);
        }
        if (!this.seconds.getValues().contains(date.getSecondOfMinute())) {
            int previousSeconds = this.seconds.getPreviousValue(date.getSecondOfMinute(), 0).getValue();
            if (previousSeconds >= date.getSecondOfMinute()) {
                return this.previousClosestMatch(date.minusSeconds(1));
            }
            return this.initDateTime(date.getYear(), date.getMonthOfYear(), date.getDayOfMonth(), date.getHourOfDay(), date.getMinuteOfHour(), previousSeconds);
        }
        return date;
    }

    public Duration timeToNextExecution(DateTime date) {
        return new Interval((ReadableInstant)date, (ReadableInstant)this.nextExecution(date)).toDuration();
    }

    public DateTime lastExecution(DateTime date) {
        Validate.notNull((Object)date);
        try {
            DateTime previousMatch = this.previousClosestMatch(date);
            if (previousMatch.equals((Object)date)) {
                previousMatch = this.previousClosestMatch(date.minusSeconds(1));
            }
            return previousMatch;
        }
        catch (NoSuchValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Duration timeFromLastExecution(DateTime date) {
        return new Interval((ReadableInstant)this.lastExecution(date), (ReadableInstant)date).toDuration();
    }

    private List<Integer> generateDayCandidates(int year, int month, WeekDay mondayDoWValue) {
        DateTime date = new DateTime(year, month, 1, 1, 1);
        HashSet candidates = Sets.newHashSet();
        candidates.addAll(FieldValueGeneratorFactory.createDayOfMonthValueGeneratorInstance(this.daysOfMonthCronField, year, month).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        candidates.addAll(FieldValueGeneratorFactory.createDayOfWeekValueGeneratorInstance(this.daysOfWeekCronField, year, month, mondayDoWValue).generateCandidates(1, date.dayOfMonth().getMaximumValue()));
        ArrayList candidatesList = Lists.newArrayList((Iterable)candidates);
        Collections.sort(candidatesList);
        return candidatesList;
    }

    private DateTime initDateTime(int years, int monthsOfYear, int dayOfMonth, int hoursOfDay, int minutesOfHour, int secondsOfMinute) {
        return new DateTime(0, 1, 1, 0, 0, 0).plusYears(years).plusMonths(monthsOfYear - 1).plusDays(dayOfMonth - 1).plusHours(hoursOfDay).plusMinutes(minutesOfHour).plusSeconds(secondsOfMinute);
    }
}

