/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.cronutils.model.field.value.SpecialChar;
import com.cronutils.model.field.value.SpecialCharFieldValue;
import org.apache.commons.lang3.Validate;

public class On
extends FieldExpression {
    private static final int DEFAULT_NTH_VALUE = -1;
    private IntegerFieldValue time;
    private IntegerFieldValue nth;
    private SpecialCharFieldValue specialChar;

    private On(On on) {
        this(on.constraints, on.time, on.specialChar, on.nth);
    }

    public On(FieldConstraints constraints, SpecialCharFieldValue specialChar) {
        this(constraints, new IntegerFieldValue(-1), specialChar);
    }

    public On(FieldConstraints constraints, IntegerFieldValue time) {
        this(constraints, time, new SpecialCharFieldValue(SpecialChar.NONE));
    }

    public On(FieldConstraints constraints, IntegerFieldValue time, SpecialCharFieldValue specialChar) {
        this(constraints, time, specialChar, new IntegerFieldValue(-1));
        if (specialChar.getValue().equals((Object)SpecialChar.HASH)) {
            throw new IllegalArgumentException("value missing for a#b cron expression");
        }
    }

    public On(FieldConstraints constraints, IntegerFieldValue time, SpecialCharFieldValue specialChar, IntegerFieldValue nth) {
        super(constraints);
        Validate.notNull((Object)time, (String)"time must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)specialChar, (String)"special char must not null", (Object[])new Object[0]);
        Validate.notNull((Object)nth, (String)"nth value must not be null", (Object[])new Object[0]);
        this.time = !specialChar.getValue().equals((Object)SpecialChar.HASH) && !specialChar.getValue().equals((Object)SpecialChar.NONE) ? (time.getValue() != -1 ? (IntegerFieldValue)this.validate(time) : time) : (IntegerFieldValue)this.validate(time);
        this.specialChar = (SpecialCharFieldValue)this.validate(specialChar);
        this.nth = nth.getValue() != -1 ? (IntegerFieldValue)this.validate(nth) : nth;
    }

    public IntegerFieldValue getTime() {
        return this.time;
    }

    public IntegerFieldValue getNth() {
        return this.nth;
    }

    public SpecialCharFieldValue getSpecialChar() {
        return this.specialChar;
    }

    @Override
    public String asString() {
        switch (this.specialChar.getValue()) {
            case NONE: {
                return "" + this.getTime();
            }
            case HASH: {
                return String.format("%s#%s", this.getTime(), this.getNth());
            }
            case W: {
                if (this.isDefault(this.getTime())) {
                    return "W";
                }
                return String.format("%sW", this.getTime());
            }
            case L: {
                if (this.isDefault(this.getTime())) {
                    return "L";
                }
                return String.format("%sL", this.getTime());
            }
        }
        return this.specialChar.toString();
    }

    private boolean isDefault(IntegerFieldValue fieldValue) {
        return fieldValue.getValue() == -1;
    }
}

