/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.mapper;

import com.cronutils.mapper.ConstantsMapper;
import com.cronutils.model.Cron;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.field.CronField;
import com.cronutils.model.field.CronFieldName;
import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.constraint.FieldConstraintsBuilder;
import com.cronutils.model.field.definition.DayOfWeekFieldDefinition;
import com.cronutils.model.field.definition.FieldDefinition;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.visitor.ValueMappingFieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class CronMapper {
    private Map<CronFieldName, Function<CronField, CronField>> mappings;
    private CronDefinition to;

    public CronMapper(CronDefinition from, CronDefinition to) {
        Validate.notNull((Object)from, (String)"Source CronDefinition must not be null", (Object[])new Object[0]);
        this.to = (CronDefinition)Validate.notNull((Object)to, (String)"Destination CronDefinition must not be null", (Object[])new Object[0]);
        this.mappings = Maps.newHashMap();
        this.buildMappings(from, to);
    }

    public Cron map(Cron cron) {
        Validate.notNull((Object)cron, (String)"Cron must not be null", (Object[])new Object[0]);
        ArrayList fields = Lists.newArrayList();
        for (CronFieldName name : CronFieldName.values()) {
            if (!this.mappings.containsKey((Object)name)) continue;
            fields.add(this.mappings.get((Object)name).apply((Object)cron.retrieve(name)));
        }
        return new Cron(this.to, fields);
    }

    private void buildMappings(CronDefinition from, CronDefinition to) {
        HashMap sourceFieldDefinitions = Maps.newHashMap();
        HashMap destFieldDefinitions = Maps.newHashMap();
        for (FieldDefinition fieldDefinition : from.getFieldDefinitions()) {
            sourceFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        for (FieldDefinition fieldDefinition : to.getFieldDefinitions()) {
            destFieldDefinitions.put(fieldDefinition.getFieldName(), fieldDefinition);
        }
        boolean startedDestMapping = false;
        boolean startedSourceMapping = false;
        for (CronFieldName name : CronFieldName.values()) {
            if (destFieldDefinitions.get((Object)name) != null) {
                startedDestMapping = true;
            }
            if (sourceFieldDefinitions.get((Object)name) != null) {
                startedSourceMapping = true;
            }
            if (startedDestMapping && destFieldDefinitions.get((Object)name) == null) break;
            if (!startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnOnZeroExpression(name));
            }
            if (startedSourceMapping && sourceFieldDefinitions.get((Object)name) == null && destFieldDefinitions.get((Object)name) != null) {
                this.mappings.put(name, CronMapper.returnAlwaysExpression(name));
            }
            if (sourceFieldDefinitions.get((Object)name) == null || destFieldDefinitions.get((Object)name) == null) continue;
            if (CronFieldName.DAY_OF_WEEK.equals((Object)name)) {
                this.mappings.put(name, CronMapper.dayOfWeekMapping((DayOfWeekFieldDefinition)sourceFieldDefinitions.get((Object)name), (DayOfWeekFieldDefinition)destFieldDefinitions.get((Object)name)));
                continue;
            }
            this.mappings.put(name, CronMapper.returnSameExpression());
        }
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnSameExpression() {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                return field;
            }
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnOnZeroExpression(final CronFieldName name) {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                FieldConstraints constraints = FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance();
                return new CronField(name, new On(constraints, new IntegerFieldValue(0)));
            }
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> returnAlwaysExpression(final CronFieldName name) {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                return new CronField(name, new Always(FieldConstraintsBuilder.instance().forField(name).createConstraintsInstance()));
            }
        };
    }

    @VisibleForTesting
    static Function<CronField, CronField> dayOfWeekMapping(final DayOfWeekFieldDefinition sourceDef, final DayOfWeekFieldDefinition targetDef) {
        return new Function<CronField, CronField>(){

            public CronField apply(CronField field) {
                FieldExpression expression = field.getExpression().accept(new ValueMappingFieldExpressionVisitor(targetDef.getConstraints(), new Function<FieldValue, FieldValue>(){

                    public FieldValue apply(FieldValue fieldValue) {
                        if (fieldValue instanceof IntegerFieldValue) {
                            return new IntegerFieldValue(ConstantsMapper.weekDayMapping(sourceDef.getMondayDoWValue(), targetDef.getMondayDoWValue(), ((IntegerFieldValue)fieldValue).getValue()));
                        }
                        return fieldValue;
                    }
                }));
                return new CronField(CronFieldName.DAY_OF_WEEK, expression);
            }
        };
    }
}

