/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.field.expression.visitor;

import com.cronutils.model.field.constraint.FieldConstraints;
import com.cronutils.model.field.expression.Always;
import com.cronutils.model.field.expression.And;
import com.cronutils.model.field.expression.Between;
import com.cronutils.model.field.expression.Every;
import com.cronutils.model.field.expression.FieldExpression;
import com.cronutils.model.field.expression.On;
import com.cronutils.model.field.expression.visitor.FieldExpressionVisitor;
import com.cronutils.model.field.value.FieldValue;
import com.cronutils.model.field.value.IntegerFieldValue;
import com.google.common.base.Function;

public class ValueMappingFieldExpressionVisitor
implements FieldExpressionVisitor {
    private FieldConstraints destinationConstraint;
    private Function<FieldValue, FieldValue> transform;

    public ValueMappingFieldExpressionVisitor(FieldConstraints destinationConstraint, Function<FieldValue, FieldValue> transform) {
        this.destinationConstraint = destinationConstraint;
        this.transform = transform;
    }

    @Override
    public Always visit(Always always) {
        return always;
    }

    @Override
    public And visit(And and) {
        And clone = new And();
        for (FieldExpression expression : and.getExpressions()) {
            clone.and(this.visit(expression));
        }
        return clone;
    }

    @Override
    public Between visit(Between between) {
        FieldValue from = (FieldValue)this.transform.apply((Object)between.getFrom());
        FieldValue to = (FieldValue)this.transform.apply((Object)between.getTo());
        return new Between(this.destinationConstraint, from, to, between.getEvery().getTime());
    }

    @Override
    public Every visit(Every every) {
        return new Every(this.destinationConstraint, (IntegerFieldValue)this.transform.apply((Object)every.getTime()));
    }

    @Override
    public On visit(On on) {
        return new On(this.destinationConstraint, (IntegerFieldValue)this.transform.apply((Object)on.getTime()), on.getSpecialChar(), on.getNth());
    }

    @Override
    public FieldExpression visit(FieldExpression expression) {
        if (expression instanceof Always) {
            return this.visit((Always)expression);
        }
        if (expression instanceof And) {
            return this.visit((And)expression);
        }
        if (expression instanceof Between) {
            return this.visit((Between)expression);
        }
        if (expression instanceof Every) {
            return this.visit((Every)expression);
        }
        if (expression instanceof On) {
            return this.visit((On)expression);
        }
        return expression;
    }
}

