/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.parser.field;

import com.cronutils.model.field.Always;
import com.cronutils.model.field.And;
import com.cronutils.model.field.Between;
import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.On;
import com.cronutils.model.field.constraint.FieldConstraints;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;

public class FieldParser {
    private final char[] specialCharsMinusStar = new char[]{'/', '-', ','};
    private FieldConstraints constraints;

    public FieldParser(FieldConstraints constraints) {
        this.constraints = (FieldConstraints)Validate.notNull((Object)constraints, (String)"FieldConstraints cannot be null", (Object[])new Object[0]);
    }

    public FieldExpression parse(String expression) {
        if (!StringUtils.containsAny((CharSequence)expression, (char[])this.specialCharsMinusStar)) {
            if ("*".equals(expression)) {
                return new Always(this.constraints);
            }
            return new On(this.constraints, expression);
        }
        String[] array = expression.split(",");
        if (array.length > 1) {
            And and = new And();
            for (String exp : array) {
                and.and(this.parse(exp));
            }
            return and;
        }
        array = expression.split("-");
        if (array.length > 1) {
            if (array[1].contains("/")) {
                String[] every = array[1].split("/");
                return new Between(this.constraints, array[0], every[0], every[1]);
            }
            return new Between(this.constraints, array[0], array[1]);
        }
        return new Every(this.constraints, expression.split("/")[1]);
    }
}

