/*
 * Decompiled with CFR 0.152.
 */
package com.cronutils.model.time.generator;

import com.cronutils.model.field.Always;
import com.cronutils.model.field.And;
import com.cronutils.model.field.Between;
import com.cronutils.model.field.Every;
import com.cronutils.model.field.FieldExpression;
import com.cronutils.model.field.On;
import com.cronutils.model.time.generator.AlwaysFieldValueGenerator;
import com.cronutils.model.time.generator.BetweenFieldValueGenerator;
import com.cronutils.model.time.generator.EveryFieldValueGenerator;
import com.cronutils.model.time.generator.FieldValueGenerator;
import com.cronutils.model.time.generator.NoSuchValueException;
import com.cronutils.model.time.generator.OnFieldValueGenerator;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class AndFieldValueGenerator
extends FieldValueGenerator {
    public AndFieldValueGenerator(FieldExpression expression) {
        super(expression);
    }

    @Override
    public int generateNextValue(final int reference) throws NoSuchValueException {
        List<Integer> candidates = this.computeCandidates(new Function<FieldValueGenerator, Integer>(){

            public Integer apply(FieldValueGenerator fieldValueGenerator) {
                try {
                    return fieldValueGenerator.generateNextValue(reference);
                }
                catch (NoSuchValueException e) {
                    return FieldValueGenerator.NO_VALUE;
                }
            }
        });
        if (candidates.isEmpty()) {
            throw new NoSuchValueException();
        }
        return candidates.get(0);
    }

    @Override
    public int generatePreviousValue(final int reference) throws NoSuchValueException {
        List<Integer> candidates = this.computeCandidates(new Function<FieldValueGenerator, Integer>(){

            public Integer apply(FieldValueGenerator candidateGenerator) {
                try {
                    return candidateGenerator.generatePreviousValue(reference);
                }
                catch (NoSuchValueException e) {
                    return FieldValueGenerator.NO_VALUE;
                }
            }
        });
        if (candidates.isEmpty()) {
            throw new NoSuchValueException();
        }
        return candidates.get(candidates.size() - 1);
    }

    @Override
    protected List<Integer> generateCandidatesNotIncludingIntervalExtremes(int start, int end) {
        ArrayList values = Lists.newArrayList();
        try {
            int reference = this.generateNextValue(start);
            while (reference < end) {
                values.add(reference);
                reference = this.generateNextValue(reference);
            }
        }
        catch (NoSuchValueException e) {
            // empty catch block
        }
        return values;
    }

    @Override
    public boolean isMatch(int value) {
        And and = (And)this.expression;
        boolean match = false;
        for (FieldExpression expression : and.getExpressions()) {
            match = match || this.createCandidateGeneratorInstance(expression).isMatch(value);
        }
        return match;
    }

    @Override
    protected boolean matchesFieldExpressionClass(FieldExpression fieldExpression) {
        return fieldExpression instanceof And;
    }

    private List<Integer> computeCandidates(Function<FieldValueGenerator, Integer> function) {
        And and = (And)this.expression;
        ArrayList<Integer> candidates = Lists.newArrayList();
        for (FieldExpression expression : and.getExpressions()) {
            candidates.add((Integer)function.apply((Object)this.createCandidateGeneratorInstance(expression)));
        }
        candidates = new ArrayList<Integer>(Collections2.filter((Collection)candidates, (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer integer) {
                return integer >= 0;
            }
        }));
        Collections.sort(candidates);
        return candidates;
    }

    private FieldValueGenerator createCandidateGeneratorInstance(FieldExpression expression) {
        if (expression instanceof Always) {
            return new AlwaysFieldValueGenerator(expression);
        }
        if (expression instanceof Between) {
            return new BetweenFieldValueGenerator(expression);
        }
        if (expression instanceof Every) {
            return new EveryFieldValueGenerator(expression);
        }
        if (expression instanceof On) {
            return new OnFieldValueGenerator(expression);
        }
        throw new IllegalArgumentException(String.format("FieldExpression %s not supported!", expression.getClass()));
    }
}

