/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.Operator;
import com.creativewidgetworks.expressionparser.TokenType;
import com.creativewidgetworks.expressionparser.Value;
import java.math.BigDecimal;
import java.util.Date;

public class Token {
    private final TokenType type;
    private Value value;
    private Value orgValue;
    private final int row;
    private final int column;
    private String text;
    private int argc;

    public Token(TokenType type, String text, int row, int column) {
        this(type, text, null, row, column);
        Value value = new Value();
        if (type != null) {
            if (TokenType.NUMBER.equals((Object)type)) {
                value = new Value("number", new BigDecimal(text));
            } else if (TokenType.STRING.equals((Object)type)) {
                value = new Value("string", text);
            }
        }
        this.setValue(value);
    }

    public Token(TokenType type, Value value, int row, int column) {
        this(type, "VALUE", value, row, column);
    }

    public Token(TokenType type, String text, Value value, int row, int column) {
        this.type = type == null ? TokenType.NOMATCH : type;
        this.text = text;
        this.row = row;
        this.column = column;
        this.value = new Value(value);
    }

    void saveOrgValue() {
        this.orgValue = new Value(this.value);
    }

    void restoreOrgValue() {
        this.value.set(this.orgValue);
    }

    public Boolean asBoolean() {
        return this.getValue() != null ? this.getValue().asBoolean() : null;
    }

    public Date asDate() {
        return this.getValue() != null ? this.getValue().asDate() : null;
    }

    public BigDecimal asNumber() {
        return this.getValue() != null ? this.getValue().asNumber() : null;
    }

    public Object asObject() {
        return this.getValue() != null ? this.getValue().asObject() : null;
    }

    public String asString() {
        return this.getValue() != null ? this.getValue().asString() : null;
    }

    public boolean equals(Operator operator) {
        return operator != null && this.getText() != null && this.getText().equalsIgnoreCase(operator.getText());
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public String getText() {
        return this.text;
    }

    public TokenType getType() {
        return this.type;
    }

    public Value getValue() {
        return this.value;
    }

    public int getArgc() {
        return this.argc;
    }

    public boolean isConstant() {
        return TokenType.CONSTANT.equals((Object)this.type);
    }

    public boolean isField() {
        return TokenType.FIELD.equals((Object)this.type);
    }

    public boolean isFunction() {
        return TokenType.FUNCTION.equals((Object)this.type);
    }

    public boolean isIdentifer() {
        return TokenType.IDENTIFIER.equals((Object)this.type);
    }

    public boolean isNumber() {
        return TokenType.NUMBER.equals((Object)this.type);
    }

    public boolean isOperator() {
        if (TokenType.OPERATOR.equals((Object)this.type)) {
            Operator op = Operator.find(this, true);
            if (op == null) {
                op = Operator.find(this, false);
            }
            return !Operator.LPAREN.equals((Object)op) && !Operator.RPAREN.equals((Object)op) && !Operator.LBRACKET.equals((Object)op) && !Operator.RBRACKET.equals((Object)op);
        }
        return false;
    }

    public boolean isParen() {
        Operator op = Operator.find(this, false);
        if (op == null) {
            op = Operator.find(this, true);
        }
        return TokenType.OPERATOR.equals((Object)this.type) && Operator.LPAREN.equals((Object)op);
    }

    public boolean isProperty() {
        return TokenType.PROPERTY.equals((Object)this.type);
    }

    public boolean isString() {
        return TokenType.STRING.equals((Object)this.type);
    }

    public Token setArgc(int argc) {
        this.argc = argc;
        return this;
    }

    public Token setText(String text) {
        this.text = text;
        return this;
    }

    public Token setValue(Value value) {
        this.value.set(value);
        return this;
    }

    public boolean opEquals(Operator ... operators) {
        boolean result = false;
        if (this.text != null && operators != null) {
            for (Operator operator : operators) {
                boolean bl = result = operator != null && this.text.equals(operator.getText());
                if (result) break;
            }
        }
        return result;
    }

    public String toString() {
        String rc = this.getRow() + "," + this.getColumn();
        String args = TokenType.FUNCTION.equals((Object)this.getType()) ? " (args=" + this.argc + ")" : "";
        return String.format("%-6s %-10s %s %s", rc, this.getType().name(), this.getText(), args);
    }
}

