/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

enum Operator {
    COMMA(1, 0, ",", ","),
    LBRACKET(1, 1, "[", "\\["),
    RBRACKET(1, 1, "]", "\\]"),
    LPAREN(1, 1, "(", "\\("),
    RPAREN(1, 1, ")", "\\)"),
    EXP(2, 0, "^", "\\^"),
    PERCENT(3, 2, "%", "%"),
    UNARY_MINUS(3, 2, "!", "!"),
    UNARY_PLUS(3, 2, "!!", "!!"),
    NOT(3, 2, "NOT", "not"),
    MULT(4, 1, "*", "\\*"),
    DIV(4, 1, "/", "/"),
    IDIV(4, 1, "DIV", "div"),
    MODULUS(4, 1, "MOD", "mod"),
    PLUS(5, 1, "+", "\\+"),
    MINUS(5, 1, "-", "-"),
    LSHIFT(6, 1, "<<", "<<"),
    RSHIFT(6, 1, ">>", ">>"),
    LT(7, 1, "<", "<"),
    LTE(7, 1, "<=", "<="),
    GT(7, 1, ">", ">"),
    GTE(7, 1, ">=", ">="),
    EQU(8, 1, "==", "=="),
    NEQ(8, 1, "!=", "!="),
    AND(12, 1, "AND", "and"),
    OR(13, 1, "OR", "or"),
    TIF(14, 2, "?", "\\?"),
    TELSE(14, 2, ":", ":"),
    ASSIGNMENT(15, 2, "=", "=");

    static final int NONE_ASSOCIATIVE = 0;
    static final int LEFT_ASSOCIATIVE = 1;
    static final int RIGHT_ASSOCIATIVE = 2;
    private static final Map<String, Operator> caseInsensitiveMap;
    private static final Map<String, Operator> caseSensitiveMap;
    private final int precedence;
    private final int association;
    private final String text;
    private final String regex;

    private Operator(int precedence, int assocation, String text, String regex) {
        this.precedence = precedence;
        this.association = assocation;
        this.text = text;
        this.regex = regex;
    }

    public static Operator find(Token token, boolean caseSensitive) {
        String key = token == null || token.getText() == null ? "" : (caseSensitive ? token.getText() : token.getText().toUpperCase());
        return caseSensitive ? caseSensitiveMap.get(key) : caseInsensitiveMap.get(key);
    }

    public boolean inSet(Operator ... operators) {
        for (Operator operator : operators) {
            if (!this.equals((Object)operator)) continue;
            return true;
        }
        return false;
    }

    public int getAssociation() {
        return this.association;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public String getText() {
        return this.text;
    }

    static String getOperatorRegex() {
        ArrayList<String> regexs = new ArrayList<String>();
        for (Operator operator : Operator.values()) {
            regexs.add(operator.regex);
        }
        Collections.sort(regexs, Collections.reverseOrder());
        StringBuilder sb = new StringBuilder();
        for (String regex : regexs) {
            if (sb.length() > 0) {
                sb.append("|");
            }
            sb.append(regex);
        }
        return sb.toString();
    }

    static {
        caseInsensitiveMap = new HashMap<String, Operator>();
        caseSensitiveMap = new HashMap<String, Operator>();
        for (Operator operator : Operator.values()) {
            caseInsensitiveMap.put(operator.text.toUpperCase(), operator);
            caseSensitiveMap.put(operator.text, operator);
        }
    }
}

