/*
 * Decompiled with CFR 0.152.
 */
package com.creativewidgetworks.expressionparser;

import com.creativewidgetworks.expressionparser.ParserException;
import com.creativewidgetworks.expressionparser.Token;
import com.creativewidgetworks.expressionparser.Value;
import com.creativewidgetworks.expressionparser.ValueType;
import java.lang.reflect.Method;
import java.util.Stack;

public class Function {
    private final String functionName;
    private final int minArgs;
    private final int maxArgs;
    private final Object javaInstance;
    private final Method javaMethod;
    private final ValueType[] parameters;

    public Function(String functionName, Object instance, String methodName, int minArgs, int maxArgs, ValueType ... types) {
        this.functionName = functionName;
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        this.parameters = types;
        this.javaInstance = instance;
        String className = instance.getClass().getName();
        try {
            this.javaMethod = instance.getClass().getMethod(methodName, Token.class, Stack.class);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalStateException("Init " + className + " NoSuchMethodException " + methodName, ex);
        }
        catch (SecurityException ex) {
            throw new IllegalStateException("Init " + className + " " + methodName, ex);
        }
    }

    public String getName() {
        return this.functionName;
    }

    public Value execute(Token function, Stack<Token> stack) throws ParserException {
        Value value;
        try {
            this.validateParameters(function, stack);
            value = (Value)this.javaMethod.invoke(this.javaInstance, function, stack);
        }
        catch (ParserException pex) {
            throw pex;
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof ParserException) {
                throw (ParserException)ex.getCause();
            }
            String msg = ex.getMessage();
            if (msg == null && (msg = ex.getCause().getMessage()) == null) {
                msg = ex.getCause().toString();
            }
            throw new ParserException(msg, (Throwable)ex, function.getRow(), function.getColumn());
        }
        return value;
    }

    private void validateParameters(Token function, Stack<Token> stack) throws ParserException {
        if (stack != null && function != null) {
            if (function.getArgc() < this.minArgs || function.getArgc() > this.maxArgs) {
                String strMaxArgs = this.maxArgs != Integer.MAX_VALUE ? String.valueOf(this.maxArgs) : "n";
                String str = this.minArgs == this.maxArgs ? String.valueOf(this.minArgs) : this.minArgs + ".." + strMaxArgs;
                String msg = ParserException.formatMessage("error.function_parameter_count", function.getText(), str, function.getArgc());
                throw new ParserException(msg, function.getRow(), function.getColumn() + function.getText().length());
            }
            if (this.parameters != null && this.parameters.length > 0) {
                for (int i = 0; i < function.getArgc() && i < this.parameters.length; ++i) {
                    Token token = (Token)stack.get(stack.size() - function.getArgc() + i);
                    if (token.getValue().asObject() == null || this.parameters[i] == token.getValue().getType() || this.parameters[i] == ValueType.UNDEFINED) continue;
                    String msg = ParserException.formatMessage("error.function_type_mismatch", function.getText(), String.valueOf(i + 1), this.parameters[i].name(), token.getValue().getType().name());
                    throw new ParserException(msg, function.getRow(), function.getColumn() + function.getText().length());
                }
            }
        }
    }
}

