/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.service.commerce.benefits;

import com.coze.openapi.api.CommerceBenefitLimitationAPI;
import com.coze.openapi.client.commerce.benefit.limitation.CreateBenefitLimitationReq;
import com.coze.openapi.client.commerce.benefit.limitation.CreateBenefitLimitationResp;
import com.coze.openapi.client.commerce.benefit.limitation.ListBenefitLimitationReq;
import com.coze.openapi.client.commerce.benefit.limitation.ListBenefitLimitationResp;
import com.coze.openapi.client.commerce.benefit.limitation.UpdateBenefitLimitationReq;
import com.coze.openapi.client.commerce.benefit.limitation.UpdateBenefitLimitationResp;
import com.coze.openapi.client.commerce.benefit.limitation.model.BenefitInfo;
import com.coze.openapi.client.common.BaseResponse;
import com.coze.openapi.client.common.pagination.PageFetcher;
import com.coze.openapi.client.common.pagination.PageRequest;
import com.coze.openapi.client.common.pagination.PageResp;
import com.coze.openapi.client.common.pagination.PageResponse;
import com.coze.openapi.client.common.pagination.TokenBasedPaginator;
import com.coze.openapi.service.utils.Utils;

public class LimitationService {
    private final CommerceBenefitLimitationAPI api;

    public LimitationService(CommerceBenefitLimitationAPI limitationAPI) {
        this.api = limitationAPI;
    }

    public CreateBenefitLimitationResp create(CreateBenefitLimitationReq req) {
        BaseResponse<CreateBenefitLimitationResp> resp = Utils.execute(this.api.create(req, req));
        CreateBenefitLimitationResp data = resp.getData();
        data.setLogID(resp.getLogID());
        return data;
    }

    public UpdateBenefitLimitationResp update(UpdateBenefitLimitationReq req) {
        String logID = Utils.execute(this.api.update(req.getBenefitID(), req, req)).getLogID();
        return ((UpdateBenefitLimitationResp.UpdateBenefitLimitationRespBuilder)UpdateBenefitLimitationResp.builder().logID(logID)).build();
    }

    public PageResp<BenefitInfo> list(ListBenefitLimitationReq req) {
        Integer pageSize = req.getPageSize();
        if (pageSize == null) {
            pageSize = 20;
        }
        PageFetcher<BenefitInfo> pageFetcher = this.getLimitationPageFetcher(req);
        TokenBasedPaginator<BenefitInfo> paginator = new TokenBasedPaginator<BenefitInfo>(pageFetcher, pageSize);
        PageRequest initialRequest = PageRequest.builder().pageSize(pageSize).pageToken(req.getPageToken()).build();
        PageResponse<BenefitInfo> currentPage = pageFetcher.fetch(initialRequest);
        paginator.setCurrentPage(currentPage);
        return PageResp.builder().items(currentPage.getData()).iterator(paginator).lastID(currentPage.getLastID()).firstID(currentPage.getFirstID()).hasMore(currentPage.isHasMore()).build();
    }

    private PageFetcher<BenefitInfo> getLimitationPageFetcher(ListBenefitLimitationReq req) {
        PageFetcher<BenefitInfo> pageFetcher = request -> {
            req.setPageToken(request.getPageToken());
            String entityType = null;
            String benefitType = null;
            String status = null;
            if (req.getEntityType() != null) {
                entityType = req.getEntityType().getValue();
            }
            if (req.getBenefitType() != null) {
                benefitType = req.getBenefitType().getValue();
            }
            if (req.getStatus() != null) {
                status = req.getStatus().getValue();
            }
            ListBenefitLimitationResp resp = Utils.execute(this.api.list(entityType, request.getPageToken(), req.getPageSize(), req.getEntityID(), benefitType, status, req)).getData();
            return PageResponse.builder().hasMore(resp.isHasMore()).pageToken(resp.getPageToken()).data(resp.getBenefitInfos()).build();
        };
        return pageFetcher;
    }
}

