/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.utils;

import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtils {
    private static final Logger logger = LoggerFactory.getLogger(VersionUtils.class);
    private static final String VERSION = VersionUtils.readVersion();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String readVersion() {
        Properties prop = new Properties();
        try (InputStream input = VersionUtils.class.getClassLoader().getResourceAsStream("version.properties");){
            if (input == null) return "";
            prop.load(input);
            String string = prop.getProperty("sdk.version", "");
            return string;
        }
        catch (Exception e) {
            logger.error("Failed to read version.properties: {}", (Object)e.getMessage());
        }
        return "";
    }

    public static String getVersion() {
        return VERSION;
    }
}

