/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.service.auth;

import com.coze.openapi.api.CozeAuthAPI;
import com.coze.openapi.client.auth.GetAccessTokenReq;
import com.coze.openapi.client.auth.GrantType;
import com.coze.openapi.client.auth.OAuthToken;
import com.coze.openapi.client.common.BaseReq;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.exception.CozeAuthException;
import com.coze.openapi.client.exception.CozeError;
import com.coze.openapi.service.auth.AuthLogFactory;
import com.coze.openapi.service.utils.UserAgentInterceptor;
import com.coze.openapi.service.utils.Utils;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.reactivex.Single;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.HashMap;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import okhttp3.ConnectionPool;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.HttpException;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.jackson.JacksonConverterFactory;

public abstract class OAuthClient {
    private static final String AuthorizeHeader = "Authorization";
    private static final ObjectMapper mapper = Utils.getMapper();
    protected final String clientSecret;
    protected final String clientID;
    protected final String baseURL;
    protected final String wwwURL;
    protected final CozeAuthAPI api;
    protected final ExecutorService executorService;
    protected final String hostName;

    protected OAuthClient(OAuthBuilder<?> builder) {
        builder.init();
        this.clientSecret = builder.clientSecret;
        this.clientID = builder.clientID;
        this.baseURL = builder.baseURL;
        this.wwwURL = builder.wwwURL != null ? builder.wwwURL : builder.baseURL.replace("api.", "www.");
        if (this.baseURL != null && !this.baseURL.isEmpty()) {
            try {
                URL url = new URL(this.baseURL);
                this.hostName = url.getHost();
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid base URL: " + this.baseURL, e);
            }
        } else {
            throw new RuntimeException("Base URL is required");
        }
        Retrofit retrofit = this.defaultRetrofit(builder.client, mapper, this.getBaseURL());
        this.api = (CozeAuthAPI)retrofit.create(CozeAuthAPI.class);
        this.executorService = builder.client.dispatcher().executorService();
    }

    protected String getOAuthURL(String redirectURI, String state) {
        return this._getOAuthURL(redirectURI, state, null, null, null);
    }

    protected String getOAuthURL(String redirectURI, String state, String workspace) {
        return this._getOAuthURL(redirectURI, state, null, null, workspace);
    }

    protected String getOAuthURL(String redirectURI, String state, String codeChallenge, String codeChallengeMethod) {
        return this._getOAuthURL(redirectURI, state, codeChallenge, codeChallengeMethod, null);
    }

    protected String getOAuthURL(String redirectURI, String state, String codeChallenge, String codeChallengeMethod, String workspaceID) {
        return this._getOAuthURL(redirectURI, state, codeChallenge, codeChallengeMethod, workspaceID);
    }

    private String _getOAuthURL(String redirectUri, String state, String codeChallenge, String codeChallengeMethod, String workspaceID) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("response_type", "code");
        if (this.clientID != null) {
            params.put("client_id", this.clientID);
        }
        if (redirectUri != null) {
            params.put("redirect_uri", redirectUri);
        }
        if (state != null) {
            params.put("state", state);
        }
        if (codeChallenge != null) {
            params.put("code_challenge", codeChallenge);
        }
        if (codeChallengeMethod != null) {
            params.put("code_challenge_method", codeChallengeMethod);
        }
        String uri = this.wwwURL + "/api/permission/oauth2/authorize";
        if (workspaceID != null) {
            uri = this.wwwURL + String.format("/api/permission/oauth2/workspace_id/%s/authorize", workspaceID);
        }
        String queryString = params.entrySet().stream().map(entry -> {
            try {
                return URLEncoder.encode((String)entry.getKey(), StandardCharsets.UTF_8.toString()) + "=" + URLEncoder.encode((String)entry.getValue(), StandardCharsets.UTF_8.toString());
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.joining("&"));
        return uri + "?" + queryString;
    }

    protected Retrofit defaultRetrofit(OkHttpClient client, ObjectMapper mapper, String baseURL) {
        return new Retrofit.Builder().baseUrl(baseURL).client(client).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).build();
    }

    private String getBaseURL() {
        return this.baseURL;
    }

    protected OAuthToken getAccessToken(GrantType type, String code, String clientSecret, String redirectURI) {
        return this.request(code, clientSecret, type, null, redirectURI);
    }

    protected OAuthToken getAccessToken(GrantType type, String clientSecret, String redirectURI) {
        return this.request(null, clientSecret, type, null, redirectURI);
    }

    protected OAuthToken getAccessToken(String secret, GetAccessTokenReq req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (secret != null) {
            headers.put(AuthorizeHeader, String.format("Bearer %s", secret));
        }
        return OAuthClient.execute(this.api.retrieve(headers, req));
    }

    protected OAuthToken getAccountAccessToken(String secret, String accountID, GetAccessTokenReq req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (secret != null) {
            headers.put(AuthorizeHeader, String.format("Bearer %s", secret));
        }
        return OAuthClient.execute(this.api.account(headers, accountID, req));
    }

    protected OAuthToken getEnterpriseAccessToken(String secret, String enterpriseID, GetAccessTokenReq req) {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (secret != null) {
            headers.put(AuthorizeHeader, String.format("Bearer %s", secret));
        }
        return OAuthClient.execute(this.api.enterprise(headers, enterpriseID, req));
    }

    protected OAuthToken refreshAccessToken(String refreshToken, String clientSecret) {
        return this.request(null, clientSecret, GrantType.REFRESH_TOKEN, refreshToken, null);
    }

    protected OAuthToken refreshAccessToken(String refreshToken) {
        return this.request(null, null, GrantType.REFRESH_TOKEN, refreshToken, null);
    }

    public void shutdownExecutor() {
        Objects.requireNonNull(this.executorService, "executorService must be set in order to shut down");
        this.executorService.shutdown();
    }

    private OAuthToken request(String code, String secret, GrantType grantType, String refreshToken, String redirectURI) {
        GetAccessTokenReq.GetAccessTokenReqBuilder<?, ?> builder = GetAccessTokenReq.builder();
        ((GetAccessTokenReq.GetAccessTokenReqBuilder)((GetAccessTokenReq.GetAccessTokenReqBuilder)((GetAccessTokenReq.GetAccessTokenReqBuilder)((GetAccessTokenReq.GetAccessTokenReqBuilder)builder.clientID(this.clientID)).grantType(grantType.getValue())).code(code)).refreshToken(refreshToken)).redirectUri(redirectURI);
        BaseReq req = builder.build();
        HashMap<String, String> headers = new HashMap<String, String>();
        if (secret != null) {
            headers.put(AuthorizeHeader, String.format("Bearer %s", secret));
        }
        return OAuthClient.execute(this.api.retrieve(headers, (GetAccessTokenReq)req));
    }

    protected static <T> T execute(Single<Response<T>> apiCall) {
        try {
            Response response = (Response)apiCall.blockingGet();
            if (!response.isSuccessful()) {
                try {
                    ResponseBody errorBody = response.errorBody();
                    Throwable throwable = null;
                    try {
                        try {
                            if (errorBody == null) {
                                throw new HttpException(response);
                            }
                            String logID = Utils.getLogID(response);
                            String errStr = errorBody.string();
                            CozeError error = (CozeError)mapper.readValue(errStr, CozeError.class);
                            throw new CozeAuthException(error, (Exception)((Object)new HttpException(response)), response.code(), logID);
                        }
                        catch (Throwable logID) {
                            throwable = logID;
                            throw logID;
                        }
                    }
                    catch (Throwable throwable2) {
                        if (errorBody != null) {
                            if (throwable != null) {
                                try {
                                    errorBody.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                errorBody.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (IOException ex) {
                    throw new HttpException(response);
                }
            }
            Object body = response.body();
            if (body instanceof BaseResp) {
                ((BaseResp)body).setLogID(Utils.getLogID(response));
            }
            return (T)body;
        }
        catch (HttpException e) {
            try {
                ResponseBody errorBody = e.response().errorBody();
                Throwable throwable = null;
                try {
                    try {
                        if (errorBody == null) {
                            throw e;
                        }
                        String logID = Utils.getLogID(e.response());
                        String errStr = e.response().errorBody().string();
                        CozeError error = (CozeError)mapper.readValue(errStr, CozeError.class);
                        throw new CozeAuthException(error, (Exception)((Object)e), e.code(), logID);
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (Throwable throwable5) {
                    if (errorBody != null) {
                        if (throwable != null) {
                            try {
                                errorBody.close();
                            }
                            catch (Throwable throwable6) {
                                throwable.addSuppressed(throwable6);
                            }
                        } else {
                            errorBody.close();
                        }
                    }
                    throw throwable5;
                }
            }
            catch (IOException ex) {
                throw e;
            }
        }
    }

    public abstract OAuthToken refreshToken(String var1);

    public static abstract class OAuthBuilder<T extends OAuthBuilder<T>> {
        protected String clientID;
        protected String clientSecret;
        protected String baseURL;
        protected String wwwURL;
        protected int readTimeout;
        protected int connectTimeout;
        protected OkHttpClient client;
        protected Logger logger;

        protected T self() {
            return (T)this;
        }

        public T clientID(String clientID) {
            this.clientID = clientID;
            return this.self();
        }

        public T clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this.self();
        }

        public T baseURL(String baseURL) {
            this.baseURL = baseURL;
            return this.self();
        }

        public T wwwURL(String wwwURL) {
            this.wwwURL = wwwURL;
            return this.self();
        }

        public T readTimeout(int readTimeout) {
            this.readTimeout = readTimeout;
            return this.self();
        }

        public T connectTimeout(int connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this.self();
        }

        public T client(OkHttpClient client) {
            this.client = client;
            return this.self();
        }

        public T logger(Logger logger) {
            this.logger = logger;
            return this.self();
        }

        public abstract OAuthClient build() throws Exception;

        protected T init() {
            if (this.logger != null) {
                AuthLogFactory.setLogger(this.logger);
            }
            if (this.baseURL == null || this.baseURL.isEmpty()) {
                this.baseURL = "https://api.coze.com";
            }
            if (this.readTimeout == 0) {
                this.readTimeout = 5000;
            }
            if (this.connectTimeout == 0) {
                this.connectTimeout = 5000;
            }
            if (this.client == null) {
                this.client = this.defaultClient(Duration.ofMillis(this.readTimeout), Duration.ofMillis(this.connectTimeout));
            } else {
                OkHttpClient.Builder builder = this.client.newBuilder();
                builder.addInterceptor((Interceptor)new UserAgentInterceptor());
                this.client = builder.build();
            }
            return this.self();
        }

        protected OkHttpClient defaultClient(Duration readTimeout, Duration connectTimeout) {
            return new OkHttpClient.Builder().connectionPool(new ConnectionPool(10, 5L, TimeUnit.MINUTES)).readTimeout(readTimeout.toMillis(), TimeUnit.MILLISECONDS).connectTimeout(connectTimeout.toMillis(), TimeUnit.MILLISECONDS).addInterceptor((Interceptor)new UserAgentInterceptor()).build();
        }
    }
}

