/*
 * Decompiled with CFR 0.152.
 */
package com.coze.openapi.client.chat.model;

import com.coze.openapi.client.chat.model.Chat;
import com.coze.openapi.client.chat.model.ChatEventType;
import com.coze.openapi.client.common.BaseResp;
import com.coze.openapi.client.connversations.message.model.Message;
import com.coze.openapi.client.exception.CozeApiException;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

public class ChatEvent
extends BaseResp {
    @JsonProperty(value="event")
    private ChatEventType event;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="message")
    private Message message;

    public static ChatEvent parseEvent(Map<String, String> eventLine, String logID) {
        ChatEventType eventType = ChatEventType.fromString(eventLine.get("event"));
        String data = eventLine.get("data");
        if (ChatEventType.DONE.equals(eventType)) {
            return ((ChatEventBuilder)((BaseResp.BaseRespBuilder)ChatEvent.builder().event(eventType)).logID(logID)).build();
        }
        if (ChatEventType.ERROR.equals(eventType)) {
            throw new CozeApiException(0, data, logID);
        }
        if (ChatEventType.CONVERSATION_MESSAGE_DELTA.equals(eventType) || ChatEventType.CONVERSATION_MESSAGE_COMPLETED.equals(eventType) || ChatEventType.CONVERSATION_AUDIO_DELTA.equals(eventType)) {
            return ((ChatEventBuilder)((BaseResp.BaseRespBuilder)((ChatEventBuilder)ChatEvent.builder().event(eventType)).message(Message.fromJson(data))).logID(logID)).build();
        }
        if (ChatEventType.CONVERSATION_CHAT_CREATED.equals(eventType) || ChatEventType.CONVERSATION_CHAT_IN_PROGRESS.equals(eventType) || ChatEventType.CONVERSATION_CHAT_COMPLETED.equals(eventType) || ChatEventType.CONVERSATION_CHAT_FAILED.equals(eventType) || ChatEventType.CONVERSATION_CHAT_REQUIRES_ACTION.equals(eventType)) {
            return ((ChatEventBuilder)((BaseResp.BaseRespBuilder)((ChatEventBuilder)ChatEvent.builder().event(eventType)).chat(Chat.fromJson(data))).logID(logID)).build();
        }
        return ((ChatEventBuilder)((BaseResp.BaseRespBuilder)ChatEvent.builder().event(eventType)).logID(logID)).build();
    }

    public boolean isDone() {
        return ChatEventType.DONE.equals(this.event) || ChatEventType.ERROR.equals(this.event);
    }

    protected ChatEvent(ChatEventBuilder<?, ?> b) {
        super(b);
        this.event = ((ChatEventBuilder)b).event;
        this.chat = ((ChatEventBuilder)b).chat;
        this.message = ((ChatEventBuilder)b).message;
    }

    public static ChatEventBuilder<?, ?> builder() {
        return new ChatEventBuilderImpl();
    }

    public ChatEventType getEvent() {
        return this.event;
    }

    public Chat getChat() {
        return this.chat;
    }

    public Message getMessage() {
        return this.message;
    }

    @JsonProperty(value="event")
    public void setEvent(ChatEventType event) {
        this.event = event;
    }

    @JsonProperty(value="chat")
    public void setChat(Chat chat) {
        this.chat = chat;
    }

    @JsonProperty(value="message")
    public void setMessage(Message message) {
        this.message = message;
    }

    public ChatEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChatEvent)) {
            return false;
        }
        ChatEvent other = (ChatEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ChatEventType this$event = this.getEvent();
        ChatEventType other$event = other.getEvent();
        if (this$event == null ? other$event != null : !this$event.equals(other$event)) {
            return false;
        }
        Chat this$chat = this.getChat();
        Chat other$chat = other.getChat();
        if (this$chat == null ? other$chat != null : !((Object)this$chat).equals(other$chat)) {
            return false;
        }
        Message this$message = this.getMessage();
        Message other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !((Object)this$message).equals(other$message));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ChatEvent;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ChatEventType $event = this.getEvent();
        result = result * 59 + ($event == null ? 43 : $event.hashCode());
        Chat $chat = this.getChat();
        result = result * 59 + ($chat == null ? 43 : ((Object)$chat).hashCode());
        Message $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : ((Object)$message).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ChatEvent(super=" + super.toString() + ", event=" + this.getEvent() + ", chat=" + this.getChat() + ", message=" + this.getMessage() + ")";
    }

    private static final class ChatEventBuilderImpl
    extends ChatEventBuilder<ChatEvent, ChatEventBuilderImpl> {
        private ChatEventBuilderImpl() {
        }

        @Override
        protected ChatEventBuilderImpl self() {
            return this;
        }

        @Override
        public ChatEvent build() {
            return new ChatEvent(this);
        }
    }

    public static abstract class ChatEventBuilder<C extends ChatEvent, B extends ChatEventBuilder<C, B>>
    extends BaseResp.BaseRespBuilder<C, B> {
        private ChatEventType event;
        private Chat chat;
        private Message message;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="event")
        public B event(ChatEventType event) {
            this.event = event;
            return (B)this.self();
        }

        @JsonProperty(value="chat")
        public B chat(Chat chat) {
            this.chat = chat;
            return (B)this.self();
        }

        @JsonProperty(value="message")
        public B message(Message message) {
            this.message = message;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ChatEvent.ChatEventBuilder(super=" + super.toString() + ", event=" + this.event + ", chat=" + this.chat + ", message=" + this.message + ")";
        }
    }
}

