/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentracing;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.msg.RequestContext;
import com.couchbase.client.core.util.Validators;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import java.time.Instant;
import java.time.temporal.ChronoUnit;

public class OpenTracingRequestSpan
implements RequestSpan {
    private final Span span;
    private final Tracer tracer;

    private OpenTracingRequestSpan(Tracer tracer, Span span) {
        Validators.notNull((Object)tracer, (String)"Tracer");
        Validators.notNull((Object)span, (String)"Span");
        this.tracer = tracer;
        this.span = span;
    }

    public static OpenTracingRequestSpan wrap(Tracer tracer, Span span) {
        return new OpenTracingRequestSpan(tracer, span);
    }

    Span span() {
        return this.span;
    }

    public void setAttribute(String key, String value) {
        this.span.setTag(key, value);
    }

    public void addEvent(String name, Instant timestamp) {
        this.span.log(ChronoUnit.MICROS.between(Instant.EPOCH, timestamp), name);
    }

    public void end() {
        try (Scope scope = this.tracer.activateSpan(this.span);){
            this.span.finish();
        }
    }

    public void requestContext(RequestContext requestContext) {
    }
}

