/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.core.deps.io.opentelemetry.instrumentation.grpc.v1_6.internal;

import com.couchbase.client.core.deps.io.grpc.Context;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ContextKey;
import io.opentelemetry.context.Scope;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ContextStorageBridge
extends Context.Storage {
    private static final Logger logger = Logger.getLogger(ContextStorageBridge.class.getName());
    private static final ContextKey<com.couchbase.client.core.deps.io.grpc.Context> GRPC_CONTEXT = ContextKey.named((String)"grpc-context");
    private static final Context.Key<Context> OTEL_CONTEXT = com.couchbase.client.core.deps.io.grpc.Context.key((String)"otel-context");
    private static final Context.Key<Scope> OTEL_SCOPE = com.couchbase.client.core.deps.io.grpc.Context.key((String)"otel-scope");
    private static final Context.Key<com.couchbase.client.core.deps.io.grpc.Context> ORIGINAL_CONTEXT = com.couchbase.client.core.deps.io.grpc.Context.key((String)"original-context");
    private static final Context.Key<com.couchbase.client.core.deps.io.grpc.Context> ORIGINAL_TO_RESTORE = com.couchbase.client.core.deps.io.grpc.Context.key((String)"original-to-restore");
    private final boolean propagateGrpcDeadline;
    private final Context.Storage originalStorage;

    public ContextStorageBridge(boolean propagateGrpcDeadline) {
        this.propagateGrpcDeadline = propagateGrpcDeadline;
        this.originalStorage = null;
    }

    public ContextStorageBridge(Context.Storage originalStorage) {
        this.propagateGrpcDeadline = false;
        this.originalStorage = originalStorage;
    }

    public com.couchbase.client.core.deps.io.grpc.Context doAttach(com.couchbase.client.core.deps.io.grpc.Context toAttach) {
        Context otelContext = Context.current();
        com.couchbase.client.core.deps.io.grpc.Context current = (com.couchbase.client.core.deps.io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            current = com.couchbase.client.core.deps.io.grpc.Context.ROOT;
        }
        if (current == toAttach) {
            com.couchbase.client.core.deps.io.grpc.Context result = current.withValue(OTEL_SCOPE, (Object)Scope.noop());
            result = this.attachOriginalContextStorage(result);
            return result;
        }
        Context base = (Context)OTEL_CONTEXT.get(toAttach);
        Context newOtelContext = base != null ? base.with(GRPC_CONTEXT, (Object)toAttach) : Context.current().with(GRPC_CONTEXT, (Object)toAttach);
        Scope scope = newOtelContext.makeCurrent();
        com.couchbase.client.core.deps.io.grpc.Context result = current.withValue(OTEL_SCOPE, (Object)scope);
        result = this.attachOriginalContextStorage(result);
        return result;
    }

    private com.couchbase.client.core.deps.io.grpc.Context attachOriginalContextStorage(com.couchbase.client.core.deps.io.grpc.Context context) {
        com.couchbase.client.core.deps.io.grpc.Context result = context;
        if (this.originalStorage != null) {
            com.couchbase.client.core.deps.io.grpc.Context originalToRestore = this.originalStorage.doAttach(result);
            result = result.withValues(ORIGINAL_CONTEXT, (Object)result, ORIGINAL_TO_RESTORE, (Object)originalToRestore);
        }
        return result;
    }

    public void detach(com.couchbase.client.core.deps.io.grpc.Context toDetach, com.couchbase.client.core.deps.io.grpc.Context toRestore) {
        Scope scope;
        if (this.originalStorage != null) {
            com.couchbase.client.core.deps.io.grpc.Context originalContext = (com.couchbase.client.core.deps.io.grpc.Context)ORIGINAL_CONTEXT.get(toRestore);
            com.couchbase.client.core.deps.io.grpc.Context originalToRestore = (com.couchbase.client.core.deps.io.grpc.Context)ORIGINAL_TO_RESTORE.get(toRestore);
            this.originalStorage.detach(originalContext, originalToRestore);
        }
        if ((scope = (Scope)OTEL_SCOPE.get(toRestore)) == null) {
            logger.log(Level.SEVERE, "Detaching context which was not attached.", new Throwable().fillInStackTrace());
        } else {
            scope.close();
        }
    }

    public com.couchbase.client.core.deps.io.grpc.Context current() {
        Context otelContext = Context.current();
        com.couchbase.client.core.deps.io.grpc.Context current = (com.couchbase.client.core.deps.io.grpc.Context)otelContext.get(GRPC_CONTEXT);
        if (current == null) {
            return com.couchbase.client.core.deps.io.grpc.Context.ROOT.withValue(OTEL_CONTEXT, (Object)otelContext);
        }
        Context previousOtelContext = (Context)OTEL_CONTEXT.get(current);
        if (previousOtelContext != otelContext) {
            com.couchbase.client.core.deps.io.grpc.Context originalCurrent;
            if (!(this.propagateGrpcDeadline || this.originalStorage == null || (originalCurrent = this.originalStorage.current()) != null && originalCurrent != com.couchbase.client.core.deps.io.grpc.Context.ROOT)) {
                current = current.fork();
            }
            return current.withValue(OTEL_CONTEXT, (Object)otelContext);
        }
        return current;
    }
}

