/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.tracing.opentelemetry;

import com.couchbase.client.core.cnc.RequestSpan;
import com.couchbase.client.core.cnc.RequestTracer;
import com.couchbase.client.tracing.opentelemetry.OpenTelemetryRequestSpan;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanBuilder;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Duration;
import reactor.core.publisher.Mono;

public class OpenTelemetryRequestTracer
implements RequestTracer {
    private final Tracer tracer;

    public static OpenTelemetryRequestTracer wrap(Tracer tracer) {
        return new OpenTelemetryRequestTracer(tracer);
    }

    private OpenTelemetryRequestTracer(Tracer tracer) {
        this.tracer = tracer;
    }

    private Span castSpan(RequestSpan requestSpan) {
        if (requestSpan == null) {
            return null;
        }
        if (requestSpan instanceof OpenTelemetryRequestSpan) {
            return ((OpenTelemetryRequestSpan)requestSpan).span();
        }
        throw new IllegalArgumentException("RequestSpan must be of type OpenTelemetryRequestSpan");
    }

    public Tracer tracer() {
        return this.tracer;
    }

    public RequestSpan requestSpan(String operationName, RequestSpan parent) {
        SpanBuilder spanBuilder = this.tracer.spanBuilder(operationName);
        if (parent != null) {
            spanBuilder.setParent(Context.current().with((ImplicitContextKeyed)this.castSpan(parent)));
        } else {
            spanBuilder.setNoParent();
        }
        Span span = spanBuilder.startSpan();
        span.makeCurrent().close();
        return OpenTelemetryRequestSpan.wrap(span);
    }

    public Mono<Void> start() {
        return Mono.empty();
    }

    public Mono<Void> stop(Duration timeout) {
        return Mono.empty();
    }
}

